/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.util.Log;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.IdlingResourceTimeoutException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicy {
    private static final String TAG = "IdlingPolicy";
    private final long idleTimeout;
    private final TimeUnit unit;
    private final ResponseAction errorHandler;

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.unit;
    }

    public void handleTimeout(List<String> object, String charSequence) {
        Object object2;
        switch (1.$SwitchMap$androidx$test$espresso$IdlingPolicy$ResponseAction[((IdlingPolicy)object2).errorHandler.ordinal()]) {
            default: {
                object = String.valueOf(object);
                charSequence = String.valueOf(object);
                int n = ((String)charSequence).length();
                StringBuilder stringBuilder = new StringBuilder(n + 24);
                object2 = new IllegalStateException(stringBuilder.append("should never reach here.").append((String)object).toString());
                throw object2;
            }
            case 2: {
                object2 = new IdlingResourceTimeoutException((List<String>)object);
                throw object2;
            }
            case 1: {
                throw AppNotIdleException.create(object, (String)charSequence);
            }
            case 3: 
        }
        object2 = String.valueOf(object);
        object = String.valueOf(object2);
        int n = ((String)object).length();
        charSequence = new StringBuilder(n + 30);
        Log.w((String)TAG, (String)((StringBuilder)charSequence).append("These resources are not idle: ").append((String)object2).toString());
    }

    Builder toBuilder() {
        Builder builder = new Builder(this);
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IdlingPolicy(Builder builder) {
        boolean bl = builder.idleTimeout > 0L;
        Preconditions.checkArgument(bl);
        this.idleTimeout = builder.idleTimeout;
        this.unit = Preconditions.checkNotNull(builder.unit);
        this.errorHandler = Preconditions.checkNotNull(builder.errorHandler);
    }

    static class Builder {
        private long idleTimeout = -1L;
        private TimeUnit unit = null;
        private ResponseAction errorHandler = null;

        public Builder() {
        }

        private Builder(IdlingPolicy idlingPolicy) {
            this.idleTimeout = idlingPolicy.idleTimeout;
            this.unit = idlingPolicy.unit;
            this.errorHandler = idlingPolicy.errorHandler;
        }

        public IdlingPolicy build() {
            IdlingPolicy idlingPolicy = new IdlingPolicy(this);
            return idlingPolicy;
        }

        public Builder withIdlingTimeout(long l) {
            this.idleTimeout = l;
            return this;
        }

        public Builder withIdlingTimeoutUnit(TimeUnit timeUnit) {
            this.unit = timeUnit;
            return this;
        }

        public Builder throwAppNotIdleException() {
            this.errorHandler = ResponseAction.THROW_APP_NOT_IDLE;
            return this;
        }

        public Builder throwIdlingResourceTimeoutException() {
            this.errorHandler = ResponseAction.THROW_IDLE_TIMEOUT;
            return this;
        }

        public Builder logWarning() {
            this.errorHandler = ResponseAction.LOG_ERROR;
            return this;
        }
    }

    private static final class ResponseAction
    extends Enum<ResponseAction> {
        public static final /* enum */ ResponseAction THROW_APP_NOT_IDLE;
        public static final /* enum */ ResponseAction THROW_IDLE_TIMEOUT;
        public static final /* enum */ ResponseAction LOG_ERROR;
        private static final /* synthetic */ ResponseAction[] $VALUES;

        public static ResponseAction[] values() {
            return (ResponseAction[])$VALUES.clone();
        }

        public static ResponseAction valueOf(String string) {
            return Enum.valueOf(ResponseAction.class, string);
        }

        static {
            ResponseAction[] responseActionArray = new ResponseAction();
            THROW_APP_NOT_IDLE = responseActionArray;
            responseActionArray = new ResponseAction();
            THROW_IDLE_TIMEOUT = responseActionArray;
            responseActionArray = new ResponseAction();
            LOG_ERROR = responseActionArray;
            responseActionArray = new ResponseAction[]{THROW_APP_NOT_IDLE, THROW_IDLE_TIMEOUT, LOG_ERROR};
            $VALUES = responseActionArray;
        }
    }
}

