/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicies {
    private static volatile IdlingPolicy masterIdlingPolicy;
    private static volatile IdlingPolicy dynamicIdlingResourceErrorPolicy;
    private static volatile IdlingPolicy dynamicIdlingResourceWarningPolicy;

    private IdlingPolicies() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setMasterPolicyTimeout(long l, TimeUnit timeUnit) {
        boolean bl = l > 0L;
        Preconditions.checkArgument(bl);
        Preconditions.checkNotNull(timeUnit);
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().withIdlingTimeout(l).withIdlingTimeoutUnit(timeUnit).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setIdlingResourceTimeout(long l, TimeUnit timeUnit) {
        boolean bl = l > 0L;
        Preconditions.checkArgument(bl);
        Preconditions.checkNotNull(timeUnit);
        dynamicIdlingResourceErrorPolicy = dynamicIdlingResourceErrorPolicy.toBuilder().withIdlingTimeout(l).withIdlingTimeoutUnit(timeUnit).build();
    }

    public static void setMasterPolicyTimeoutWhenDebuggerAttached(boolean bl) {
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().build();
    }

    public static IdlingPolicy getMasterIdlingPolicy() {
        return masterIdlingPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceWarningPolicy() {
        return dynamicIdlingResourceWarningPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceErrorPolicy() {
        return dynamicIdlingResourceErrorPolicy;
    }

    static {
        IdlingPolicy.Builder builder = new IdlingPolicy.Builder();
        masterIdlingPolicy = builder.withIdlingTimeout(60L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwAppNotIdleException().build();
        builder = new IdlingPolicy.Builder();
        dynamicIdlingResourceErrorPolicy = builder.withIdlingTimeout(26L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwIdlingResourceTimeoutException().build();
        builder = new IdlingPolicy.Builder();
        dynamicIdlingResourceWarningPolicy = builder.withIdlingTimeout(5L).withIdlingTimeoutUnit(TimeUnit.SECONDS).logWarning().build();
    }
}

