/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.ViewParent;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.action.AdapterDataLoaderAction;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.action.AdapterViewProtocols;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.ConstructorInvocation;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.EspressoOptional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class DataInteraction {
    private final Matcher<? extends Object> dataMatcher;
    private Matcher<View> adapterMatcher = ViewMatchers.isAssignableFrom(AdapterView.class);
    private EspressoOptional<Matcher<View>> childViewMatcher = EspressoOptional.absent();
    private EspressoOptional<Integer> atPosition = EspressoOptional.absent();
    private AdapterViewProtocol adapterViewProtocol = AdapterViewProtocols.standardProtocol();
    private Matcher<Root> rootMatcher = RootMatchers.DEFAULT;

    DataInteraction(Matcher<? extends Object> matcher) {
        this.dataMatcher = Preconditions.checkNotNull(matcher);
    }

    public DataInteraction onChildView(Matcher<View> matcher) {
        this.childViewMatcher = EspressoOptional.of(Preconditions.checkNotNull(matcher));
        return this;
    }

    public DataInteraction inRoot(Matcher<Root> matcher) {
        this.rootMatcher = Preconditions.checkNotNull(matcher);
        return this;
    }

    public DataInteraction inAdapterView(Matcher<View> matcher) {
        this.adapterMatcher = Preconditions.checkNotNull(matcher);
        return this;
    }

    public DataInteraction atPosition(Integer n) {
        this.atPosition = EspressoOptional.of(Preconditions.checkNotNull(n));
        return this;
    }

    public DataInteraction usingAdapterViewProtocol(AdapterViewProtocol adapterViewProtocol) {
        this.adapterViewProtocol = Preconditions.checkNotNull(adapterViewProtocol);
        return this;
    }

    public ViewInteraction perform(ViewAction ... viewActionArray) {
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).perform(viewActionArray);
    }

    public ViewInteraction check(ViewAssertion viewAssertion) {
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).check(viewAssertion);
    }

    private Matcher<View> makeTargetMatcher() {
        DisplayDataMatcher displayDataMatcher = DisplayDataMatcher.displayDataMatcher(this.adapterMatcher, this.dataMatcher, this.rootMatcher, this.atPosition, this.adapterViewProtocol);
        if (this.childViewMatcher.isPresent()) {
            return Matchers.allOf(this.childViewMatcher.get(), ViewMatchers.isDescendantOfA((Matcher<View>)displayDataMatcher));
        }
        return displayDataMatcher;
    }

    public static final class DisplayDataMatcher
    extends TypeSafeMatcher<View> {
        private static final String TAG = "DisplayDataMatcher";
        @RemoteMsgField(order=0)
        private final Matcher<View> adapterMatcher;
        @RemoteMsgField(order=1)
        private final Matcher<? extends Object> dataMatcher;
        @RemoteMsgField(order=2)
        private final Class<? extends AdapterViewProtocol> adapterViewProtocolClass;
        @RemoteMsgField(order=3)
        private final AdapterDataLoaderAction adapterDataLoaderAction;
        private final AdapterViewProtocol adapterViewProtocol;

        @RemoteMsgConstructor
        DisplayDataMatcher(Matcher<View> matcher, Matcher<? extends Object> matcher2, Class<? extends AdapterViewProtocol> clazz, AdapterDataLoaderAction adapterDataLoaderAction) throws IllegalAccessException, InstantiationException {
            Matcher<Root> matcher3 = RootMatchers.DEFAULT;
            ConstructorInvocation constructorInvocation = new ConstructorInvocation(clazz, null, new Class[0]);
            this(matcher, matcher2, matcher3, clazz.cast(constructorInvocation.invokeConstructor(new Object[0])), adapterDataLoaderAction);
        }

        private DisplayDataMatcher(final Matcher<View> matcher, Matcher<? extends Object> matcher2, final Matcher<Root> matcher3, AdapterViewProtocol adapterViewProtocol, AdapterDataLoaderAction adapterDataLoaderAction) {
            Function<AdapterDataLoaderAction, ViewInteraction> function = new Function<AdapterDataLoaderAction, ViewInteraction>(){

                @Override
                public ViewInteraction apply(AdapterDataLoaderAction adapterDataLoaderAction) {
                    Object object = object2.matcher;
                    object = Espresso.onView((Matcher<View>)object);
                    Object object2 = object2.matcher3;
                    object2 = ((ViewInteraction)object).inRoot((Matcher<Root>)object2);
                    object = new ViewAction[]{adapterDataLoaderAction};
                    return ((ViewInteraction)object2).perform((ViewAction[])object);
                }
            };
            this(matcher, matcher2, adapterViewProtocol, adapterDataLoaderAction, function);
        }

        DisplayDataMatcher(Matcher<View> matcher, Matcher<? extends Object> matcher2, AdapterViewProtocol adapterViewProtocol, AdapterDataLoaderAction adapterDataLoaderAction, Function<AdapterDataLoaderAction, ViewInteraction> function) {
            this.adapterMatcher = Preconditions.checkNotNull(matcher);
            this.dataMatcher = Preconditions.checkNotNull(matcher2);
            this.adapterViewProtocol = Preconditions.checkNotNull(adapterViewProtocol);
            this.adapterViewProtocolClass = adapterViewProtocol.getClass();
            this.adapterDataLoaderAction = Preconditions.checkNotNull(adapterDataLoaderAction);
            Preconditions.checkNotNull(function).apply(adapterDataLoaderAction);
        }

        public static DisplayDataMatcher displayDataMatcher(Matcher<View> matcher, Matcher<? extends Object> matcher2, Matcher<Root> matcher3, EspressoOptional<Integer> espressoOptional, AdapterViewProtocol adapterViewProtocol) {
            AdapterDataLoaderAction adapterDataLoaderAction = new AdapterDataLoaderAction(matcher2, espressoOptional, adapterViewProtocol);
            DisplayDataMatcher displayDataMatcher = new DisplayDataMatcher(matcher, matcher2, matcher3, adapterViewProtocol, adapterDataLoaderAction);
            return displayDataMatcher;
        }

        public void describeTo(Description description) {
            description.appendText(" displaying data matching: ");
            this.dataMatcher.describeTo(description);
            description.appendText(" within adapter view matching: ");
            this.adapterMatcher.describeTo(description);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesSafely(View object) {
            ViewParent viewParent;
            boolean bl = this.adapterViewProtocol != null;
            Preconditions.checkState(bl, "adapterViewProtocol cannot be null!");
            for (viewParent = object.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
            }
            if (viewParent != null && this.adapterMatcher.matches((Object)viewParent) && ((EspressoOptional)(object = this.adapterViewProtocol.getDataRenderedByView((AdapterView<? extends Adapter>)((AdapterView)viewParent), (View)object))).isPresent()) {
                return ((AdapterViewProtocol.AdaptedData)((EspressoOptional)object).get()).opaqueToken.equals(this.adapterDataLoaderAction.getAdaptedData().opaqueToken);
            }
            return false;
        }
    }
}

