/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionComponent;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.ViewInteractionModule_ProvideNeedsActivityFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRemoteInteractionFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootMatcherFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootViewFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewFinderFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewMatcherFactory;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.BaseLayerModule;
import androidx.test.espresso.base.BaseLayerModule_FailureHandlerHolder_Factory;
import androidx.test.espresso.base.BaseLayerModule_ProvideActiveRootListerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideControlledLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDefaultFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDynamicNotiferFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideEventInjectorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHandlerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideLifecycleMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainThreadExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideRemoteExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideTargetContextFactory;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingResourceRegistry_Factory;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.RootViewPicker_Factory;
import androidx.test.espresso.base.RootViewPicker_RootResultFetcher_Factory;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.RootsOracle_Factory;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor_Factory;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.espresso.base.UiControllerImpl_Factory;
import androidx.test.espresso.base.UiControllerModule;
import androidx.test.espresso.base.UiControllerModule_ProvideUiControllerFactory;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.base.ViewFinderImpl_Factory;
import androidx.test.espresso.core.internal.deps.dagger.internal.DoubleCheck;
import androidx.test.espresso.core.internal.deps.dagger.internal.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class DaggerBaseLayerComponent
implements BaseLayerComponent {
    private final BaseLayerModule baseLayerModule;
    private Provider<Context> provideTargetContextProvider;
    private Provider<DefaultFailureHandler> provideDefaultFailureHanderProvider;
    private Provider<FailureHandler> provideFailureHanderProvider;
    private Provider<BaseLayerModule.FailureHandlerHolder> failureHandlerHolderProvider;
    private Provider<Looper> provideMainLooperProvider;
    private Provider<IdlingResourceRegistry> idlingResourceRegistryProvider;
    private Provider provideEventInjectorProvider;
    private Provider threadPoolExecutorExtractorProvider;
    private Provider provideSdkAsyncTaskMonitorProvider;
    private Provider provideCompatAsyncTaskMonitorProvider;
    private Provider provideDynamicNotiferProvider;
    private Provider uiControllerImplProvider;
    private Provider<UiController> provideUiControllerProvider;
    private Provider<Executor> provideMainThreadExecutorProvider;
    private Provider<ControlledLooper> provideControlledLooperProvider;
    private Provider rootsOracleProvider;
    private Provider<ActiveRootLister> provideActiveRootListerProvider;
    private Provider<ActivityLifecycleMonitor> provideLifecycleMonitorProvider;
    private Provider<ListeningExecutorService> provideRemoteExecutorProvider;

    private DaggerBaseLayerComponent(BaseLayerModule baseLayerModule, UiControllerModule uiControllerModule) {
        this.baseLayerModule = baseLayerModule;
        this.initialize(baseLayerModule, uiControllerModule);
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    public static BaseLayerComponent create() {
        Builder builder = new Builder();
        return builder.build();
    }

    private Object getRootsOracle() {
        return RootsOracle_Factory.newInstance((Looper)this.provideMainLooperProvider.get());
    }

    private void initialize(BaseLayerModule baseLayerModule, UiControllerModule uiControllerModule) {
        this.provideTargetContextProvider = BaseLayerModule_ProvideTargetContextFactory.create(baseLayerModule);
        this.provideDefaultFailureHanderProvider = BaseLayerModule_ProvideDefaultFailureHanderFactory.create(baseLayerModule, this.provideTargetContextProvider);
        this.provideFailureHanderProvider = BaseLayerModule_ProvideFailureHanderFactory.create(baseLayerModule, this.provideDefaultFailureHanderProvider);
        this.failureHandlerHolderProvider = DoubleCheck.provider(BaseLayerModule_FailureHandlerHolder_Factory.create(this.provideFailureHanderProvider));
        this.provideMainLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainLooperFactory.create(baseLayerModule));
        this.idlingResourceRegistryProvider = DoubleCheck.provider(IdlingResourceRegistry_Factory.create(this.provideMainLooperProvider));
        this.provideEventInjectorProvider = DoubleCheck.provider(BaseLayerModule_ProvideEventInjectorFactory.create(baseLayerModule));
        this.threadPoolExecutorExtractorProvider = DoubleCheck.provider(ThreadPoolExecutorExtractor_Factory.create(this.provideMainLooperProvider));
        this.provideSdkAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory.create(baseLayerModule, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
        this.provideCompatAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory.create(baseLayerModule, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
        this.provideDynamicNotiferProvider = BaseLayerModule_ProvideDynamicNotiferFactory.create(baseLayerModule, this.idlingResourceRegistryProvider);
        this.uiControllerImplProvider = DoubleCheck.provider(UiControllerImpl_Factory.create((Provider<EventInjector>)this.provideEventInjectorProvider, (Provider<IdleNotifier<Runnable>>)this.provideSdkAsyncTaskMonitorProvider, (Provider<IdleNotifier<Runnable>>)this.provideCompatAsyncTaskMonitorProvider, (Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>>)this.provideDynamicNotiferProvider, this.provideMainLooperProvider, this.idlingResourceRegistryProvider));
        this.provideUiControllerProvider = DoubleCheck.provider(UiControllerModule_ProvideUiControllerFactory.create(uiControllerModule, (Provider<UiControllerImpl>)this.uiControllerImplProvider));
        this.provideMainThreadExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainThreadExecutorFactory.create(baseLayerModule, this.provideMainLooperProvider));
        this.provideControlledLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideControlledLooperFactory.create(baseLayerModule));
        this.rootsOracleProvider = RootsOracle_Factory.create(this.provideMainLooperProvider);
        this.provideActiveRootListerProvider = BaseLayerModule_ProvideActiveRootListerFactory.create(baseLayerModule, (Provider<RootsOracle>)this.rootsOracleProvider);
        this.provideLifecycleMonitorProvider = BaseLayerModule_ProvideLifecycleMonitorFactory.create(baseLayerModule);
        this.provideRemoteExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideRemoteExecutorFactory.create(baseLayerModule));
    }

    @Override
    public BaseLayerModule.FailureHandlerHolder failureHolder() {
        return (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get();
    }

    @Override
    public FailureHandler failureHandler() {
        return BaseLayerModule_ProvideFailureHandlerFactory.provideFailureHandler(this.baseLayerModule, (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get());
    }

    @Override
    public ActiveRootLister activeRootLister() {
        return BaseLayerModule_ProvideActiveRootListerFactory.provideActiveRootLister(this.baseLayerModule, this.getRootsOracle());
    }

    @Override
    public IdlingResourceRegistry idlingResourceRegistry() {
        return (IdlingResourceRegistry)this.idlingResourceRegistryProvider.get();
    }

    @Override
    public UiController uiController() {
        return (UiController)this.provideUiControllerProvider.get();
    }

    @Override
    public Executor mainThreadExecutor() {
        return (Executor)this.provideMainThreadExecutorProvider.get();
    }

    @Override
    public ControlledLooper controlledLooper() {
        return (ControlledLooper)this.provideControlledLooperProvider.get();
    }

    @Override
    public ViewInteractionComponent plus(ViewInteractionModule viewInteractionModule) {
        Preconditions.checkNotNull(viewInteractionModule);
        ViewInteractionComponentImpl viewInteractionComponentImpl = new ViewInteractionComponentImpl(viewInteractionModule);
        return viewInteractionComponentImpl;
    }

    private final class ViewInteractionComponentImpl
    implements ViewInteractionComponent {
        private final ViewInteractionModule viewInteractionModule;
        private Provider<AtomicReference<Matcher<Root>>> provideRootMatcherProvider;
        private Provider rootResultFetcherProvider;
        private Provider<AtomicReference<Boolean>> provideNeedsActivityProvider;
        private Provider<RootViewPicker> rootViewPickerProvider;
        private Provider<View> provideRootViewProvider;

        private ViewInteractionComponentImpl(ViewInteractionModule viewInteractionModule) {
            this.viewInteractionModule = viewInteractionModule;
            this.initialize(viewInteractionModule);
        }

        private ViewFinderImpl getViewFinderImpl() {
            return ViewFinderImpl_Factory.newInstance(ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), this.provideRootViewProvider);
        }

        private ViewFinder getViewFinder() {
            return ViewInteractionModule_ProvideViewFinderFactory.provideViewFinder(this.viewInteractionModule, this.getViewFinderImpl());
        }

        private void initialize(ViewInteractionModule viewInteractionModule) {
            this.provideRootMatcherProvider = ViewInteractionModule_ProvideRootMatcherFactory.create(viewInteractionModule);
            this.rootResultFetcherProvider = RootViewPicker_RootResultFetcher_Factory.create((Provider<ActiveRootLister>)DaggerBaseLayerComponent.this.provideActiveRootListerProvider, this.provideRootMatcherProvider);
            this.provideNeedsActivityProvider = ViewInteractionModule_ProvideNeedsActivityFactory.create(viewInteractionModule);
            this.rootViewPickerProvider = DoubleCheck.provider(RootViewPicker_Factory.create((Provider<UiController>)DaggerBaseLayerComponent.this.provideUiControllerProvider, (Provider<RootViewPicker.RootResultFetcher>)this.rootResultFetcherProvider, (Provider<ActivityLifecycleMonitor>)DaggerBaseLayerComponent.this.provideLifecycleMonitorProvider, this.provideNeedsActivityProvider, (Provider<ControlledLooper>)DaggerBaseLayerComponent.this.provideControlledLooperProvider));
            this.provideRootViewProvider = ViewInteractionModule_ProvideRootViewFactory.create(viewInteractionModule, this.rootViewPickerProvider);
        }

        @Override
        public ViewInteraction viewInteraction() {
            ViewInteraction viewInteraction = new ViewInteraction((UiController)DaggerBaseLayerComponent.this.provideUiControllerProvider.get(), this.getViewFinder(), (Executor)DaggerBaseLayerComponent.this.provideMainThreadExecutorProvider.get(), DaggerBaseLayerComponent.this.failureHandler(), ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideRootMatcherFactory.provideRootMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideNeedsActivityFactory.provideNeedsActivity(this.viewInteractionModule), ViewInteractionModule_ProvideRemoteInteractionFactory.provideRemoteInteraction(this.viewInteractionModule), (ListeningExecutorService)DaggerBaseLayerComponent.this.provideRemoteExecutorProvider.get(), (ControlledLooper)DaggerBaseLayerComponent.this.provideControlledLooperProvider.get());
            return viewInteraction;
        }
    }

    public static final class Builder {
        private BaseLayerModule baseLayerModule;
        private UiControllerModule uiControllerModule;

        private Builder() {
        }

        public Builder baseLayerModule(BaseLayerModule baseLayerModule) {
            this.baseLayerModule = Preconditions.checkNotNull(baseLayerModule);
            return this;
        }

        public Builder uiControllerModule(UiControllerModule uiControllerModule) {
            this.uiControllerModule = Preconditions.checkNotNull(uiControllerModule);
            return this;
        }

        public BaseLayerComponent build() {
            Object object;
            if (this.baseLayerModule == null) {
                this.baseLayerModule = object = new BaseLayerModule();
            }
            if (this.uiControllerModule == null) {
                this.uiControllerModule = object = new UiControllerModule();
            }
            object = new DaggerBaseLayerComponent(this.baseLayerModule, this.uiControllerModule);
            return object;
        }
    }
}

