/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.content.res.Resources;
import android.database.Cursor;
import android.os.Build;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.Locale;

public final class HumanReadables {
    private HumanReadables() {
    }

    public static String getViewHierarchyErrorMessage(View view, final List<View> list, String string, final String string2) {
        Preconditions.checkArgument(list == null || string2 != null);
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append(String.format(Locale.ROOT, "\nProblem views are marked with '%s' below.", string2));
        }
        stringBuilder.append("\n\nView Hierarchy:\n");
        Joiner.on("\n").appendTo(stringBuilder, Iterables.transform(TreeIterables.depthFirstViewTraversalWithDistance(view), new Function<TreeIterables.ViewAndDistance, String>(){

            @Override
            public String apply(TreeIterables.ViewAndDistance viewAndDistance) {
                String string = "+%s%s ";
                if (list != null && list.contains(viewAndDistance.getView())) {
                    String string22 = String.valueOf(string);
                    String string3 = String.valueOf(string2);
                    string = string3.length() != 0 ? string22.concat(string3) : new String(string22);
                }
                string = String.valueOf(string).concat("\n|");
                return String.format(Locale.ROOT, string, Strings.padStart(">", viewAndDistance.getDistanceFromRoot() + 1, '-'), HumanReadables.describe(viewAndDistance.getView()));
            }
        }));
        return stringBuilder.toString();
    }

    public static String describe(Cursor cursor) {
        if (cursor.isBeforeFirst()) {
            return "Cursor positioned before first element.";
        }
        if (cursor.isAfterLast()) {
            return "Cursor positioned after last element.";
        }
        StringBuilder stringBuilder = new StringBuilder("Row ").append(cursor.getPosition()).append(": {");
        String[] stringArray = cursor.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(":");
            int n = 3;
            if (Build.VERSION.SDK_INT > 10) {
                n = cursor.getType(i);
            }
            switch (n) {
                case 3: {
                    stringBuilder.append("\"").append(cursor.getString(i)).append("\"");
                    break;
                }
                case 1: {
                    stringBuilder.append(cursor.getLong(i));
                    break;
                }
                case 2: {
                    stringBuilder.append(cursor.getDouble(i));
                    stringBuilder.append("f");
                    break;
                }
                case 0: {
                    stringBuilder.append("null");
                    break;
                }
                case 4: {
                    byte[] byArray = cursor.getBlob(i);
                    stringBuilder.append("[");
                    for (int j = 0; j < 5 && j < byArray.length; ++j) {
                        stringBuilder.append(byArray[j]);
                        stringBuilder.append(",");
                    }
                    if (5 < byArray.length) {
                        stringBuilder.append("... (").append(byArray.length - 5).append(" more elements)");
                    }
                    stringBuilder.append("]");
                    break;
                }
                default: {
                    stringBuilder.append("\"").append(cursor.getString(i)).append("\"");
                }
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String describe(View view) {
        EditorInfo editorInfo;
        InputConnection inputConnection;
        if (null == view) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(view).add("id", view.getId());
        if (view.getId() != -1 && view.getResources() != null && !HumanReadables.isViewIdGenerated(view.getId())) {
            try {
                toStringHelper.add("res-name", view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (null != view.getContentDescription()) {
            toStringHelper.add("desc", view.getContentDescription());
        }
        switch (view.getVisibility()) {
            case 8: {
                toStringHelper.add("visibility", "GONE");
                break;
            }
            case 4: {
                toStringHelper.add("visibility", "INVISIBLE");
                break;
            }
            case 0: {
                toStringHelper.add("visibility", "VISIBLE");
                break;
            }
            default: {
                toStringHelper.add("visibility", view.getVisibility());
            }
        }
        toStringHelper.add("width", view.getWidth()).add("height", view.getHeight()).add("has-focus", view.hasFocus()).add("has-focusable", view.hasFocusable()).add("has-window-focus", view.hasWindowFocus()).add("is-clickable", view.isClickable()).add("is-enabled", view.isEnabled()).add("is-focused", view.isFocused()).add("is-focusable", view.isFocusable()).add("is-layout-requested", view.isLayoutRequested()).add("is-selected", view.isSelected()).add("layout-params", view.getLayoutParams()).add("tag", view.getTag());
        if (null != view.getRootView()) {
            toStringHelper.add("root-is-layout-requested", view.getRootView().isLayoutRequested());
        }
        boolean bl = (inputConnection = view.onCreateInputConnection(editorInfo = new EditorInfo())) != null;
        toStringHelper.add("has-input-connection", bl);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            StringBuilderPrinter stringBuilderPrinter = new StringBuilderPrinter(stringBuilder);
            editorInfo.dump((Printer)stringBuilderPrinter, "");
            stringBuilder.append("]");
            toStringHelper.add("editor-info", stringBuilder.toString().replace("\n", " "));
        }
        if (Build.VERSION.SDK_INT > 10) {
            toStringHelper.add("x", view.getX()).add("y", view.getY());
        }
        if (view instanceof TextView) {
            HumanReadables.innerDescribe((TextView)view, toStringHelper);
        }
        if (view instanceof Checkable) {
            HumanReadables.innerDescribe((Checkable)view, toStringHelper);
        }
        if (view instanceof ViewGroup) {
            HumanReadables.innerDescribe((ViewGroup)view, toStringHelper);
        }
        return toStringHelper.toString();
    }

    private static void innerDescribe(TextView textView, MoreObjects.ToStringHelper toStringHelper) {
        if (null != textView.getText()) {
            toStringHelper.add("text", textView.getText());
        }
        if (null != textView.getError()) {
            toStringHelper.add("error-text", textView.getError());
        }
        if (null != textView.getHint()) {
            toStringHelper.add("hint", textView.getHint());
        }
        toStringHelper.add("input-type", textView.getInputType());
        toStringHelper.add("ime-target", textView.isInputMethodTarget());
        toStringHelper.add("has-links", textView.getUrls().length > 0);
    }

    private static void innerDescribe(Checkable checkable, MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("is-checked", checkable.isChecked());
    }

    private static void innerDescribe(ViewGroup viewGroup, MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("child-count", viewGroup.getChildCount());
    }

    private static boolean isViewIdGenerated(int n) {
        return (n & 0xFF000000) == 0 && (n & 0xFFFFFF) != 0;
    }
}

