/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

final class MethodInvocation {
    private static final String TAG = "MethodInvocation";
    private static final Cache<MethodKey, Method> methodCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    private final Class<?> clazz;
    private final Object instance;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodInvocation(Class<?> clazz, Object object, String string, Class<?> ... classArray) {
        this.clazz = Preconditions.checkNotNull(clazz, "clazz cannot be null!");
        this.instance = object;
        Preconditions.checkArgument(string != null && !string.isEmpty(), "methodName cannot be null or empty");
        this.methodName = string;
        this.parameterTypes = classArray;
    }

    private static Method getMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, false);
    }

    private static Method getDeclaredMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, true);
    }

    private static Method getMethodInternal(MethodKey methodKey, boolean bl) throws NoSuchMethodException {
        Method method = methodCache.getIfPresent(methodKey);
        if (null == method) {
            LogUtil.logDebug((String)TAG, (String)"Cache miss for method: %s#%s(%s). Loading into cache.", (Object[])new Object[]{methodKey.type.getSimpleName(), methodKey.methodName, Arrays.toString(methodKey.parameterTypes)});
            method = bl ? methodKey.type.getDeclaredMethod(methodKey.methodName, methodKey.parameterTypes) : methodKey.type.getMethod(methodKey.methodName, methodKey.parameterTypes);
            methodCache.put(methodKey, method);
        } else {
            LogUtil.logDebug((String)TAG, (String)"Cache hit for method: %s#%s(%s).", (Object[])new Object[]{methodKey.type.getSimpleName(), methodKey.methodName, Arrays.toString(methodKey.parameterTypes)});
        }
        return method;
    }

    public static void invalidateCache() {
        methodCache.invalidateAll();
    }

    public Object invokeDeclaredMethod(Object ... objectArray) {
        try {
            return this.invokeMethodExplosively(MethodInvocation.getDeclaredMethod(new MethodKey(this.clazz, this.methodName, this.parameterTypes)), objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RemoteProtocolException(String.format(Locale.ROOT, "No method: %s(%s) found for clazz: %s Available methods: %s", this.methodName, Arrays.asList(this.parameterTypes), this.clazz.getName(), Arrays.asList(this.clazz.getDeclaredMethods())), noSuchMethodException);
        }
    }

    public Object invokeMethod(Object ... objectArray) {
        try {
            return this.invokeMethodExplosively(MethodInvocation.getMethod(new MethodKey(this.clazz, this.methodName, this.parameterTypes)), objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RemoteProtocolException(String.format(Locale.ROOT, "No method: %s found for clazz: %s. Available methods: %s", this.methodName, this.clazz.getName(), Arrays.asList(this.clazz.getMethods())), noSuchMethodException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeMethodExplosively(Method method, Object ... objectArray) {
        Object object = null;
        try {
            method.setAccessible(true);
            object = method.invoke(this.instance, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot invoke method %s with args [%s] on builder %s", method, Arrays.toString(objectArray), this.clazz.getName()), invocationTargetException);
                catch (IllegalAccessException illegalAccessException) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Cannot create instance of %s", this.clazz.getName()), illegalAccessException);
                }
                catch (SecurityException securityException) {
                    throw new RemoteProtocolException(String.format(Locale.ROOT, "Method not accessible: %s", method.getName()), securityException);
                }
            }
            catch (Throwable throwable) {
                LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(objectArray)});
                throw throwable;
            }
        }
        LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(objectArray)});
        return object;
    }

    private static final class MethodKey {
        private final Class<?> type;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        public MethodKey(Class<?> clazz, String string, Class<?>[] classArray) {
            this.type = clazz;
            this.methodName = string;
            this.parameterTypes = classArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (null == object || this.getClass() != object.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)object;
            if (!this.type.equals(methodKey.type)) {
                return false;
            }
            if (!this.methodName.equals(methodKey.methodName)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
        }

        public int hashCode() {
            int n = this.type.hashCode();
            n = 31 * n + this.methodName.hashCode();
            n = 31 * n + Arrays.hashCode(this.parameterTypes);
            return n;
        }
    }
}

