/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.test.annotation.Beta;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Beta
public final class HasBackgroundMatcher
extends TypeSafeMatcher<View> {
    private static final String TAG = "HasBackgroundMatcher";
    private final int drawableId;

    public HasBackgroundMatcher(int n) {
        this.drawableId = n;
    }

    protected boolean matchesSafely(View view) {
        return HasBackgroundMatcher.assertDrawable(view.getBackground(), this.drawableId, view);
    }

    public void describeTo(Description description) {
        int n = this.drawableId;
        description.appendText(new StringBuilder(44).append("has background with drawable ID: ").append(n).toString());
    }

    static boolean compareBitmaps(Bitmap bitmap, Bitmap bitmap2) {
        if (bitmap.getWidth() == bitmap2.getWidth() && bitmap.getHeight() == bitmap2.getHeight()) {
            int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
            int[] nArray2 = new int[bitmap2.getWidth() * bitmap2.getHeight()];
            bitmap.getPixels(nArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
            bitmap2.getPixels(nArray2, 0, bitmap2.getWidth(), 0, 0, bitmap2.getWidth(), bitmap2.getHeight());
            return Arrays.equals(nArray, nArray2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean assertDrawable(Drawable drawable, int n, View view) {
        if (null == drawable || !(drawable instanceof BitmapDrawable)) {
            return false;
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeResource((Resources)view.getContext().getResources(), (int)n);
            if (Build.VERSION.SDK_INT >= 12) {
                boolean bl = ((BitmapDrawable)drawable).getBitmap().sameAs(bitmap);
                return bl;
            }
            boolean bl = HasBackgroundMatcher.compareBitmaps(((BitmapDrawable)drawable).getBitmap(), bitmap);
            return bl;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)TAG, (String)outOfMemoryError.getMessage(), (Throwable)outOfMemoryError.getCause());
            boolean bl = false;
            return bl;
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
                bitmap = null;
            }
        }
    }
}

