/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.BoundedMatcher;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public final class CursorMatchers {
    private static final int COLUMN_NOT_FOUND = -1;
    private static final int MULTIPLE_COLUMNS_FOUND = -2;
    private static final int USE_COLUMN_PICKER = -3;
    private static final MatcherApplier BLOB_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getBlob(n));
        }

        public void describeTo(Description description) {
            description.appendText("with Blob");
        }
    };
    private static final MatcherApplier LONG_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getLong(n));
        }

        public void describeTo(Description description) {
            description.appendText("with Long");
        }
    };
    private static final MatcherApplier SHORT_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getShort(n));
        }

        public void describeTo(Description description) {
            description.appendText("with Short");
        }
    };
    private static final MatcherApplier INT_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getInt(n));
        }

        public void describeTo(Description description) {
            description.appendText("with Int");
        }
    };
    private static final MatcherApplier FLOAT_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)Float.valueOf(cursor.getFloat(n)));
        }

        public void describeTo(Description description) {
            description.appendText("with Float");
        }
    };
    private static final MatcherApplier DOUBLE_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getDouble(n));
        }

        public void describeTo(Description description) {
            description.appendText("with Double");
        }
    };
    private static final MatcherApplier STRING_MATCHER_APPLIER = new MatcherApplier(){

        @Override
        public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
            return matcher.matches((Object)cursor.getString(n));
        }

        public void describeTo(Description description) {
            description.appendText("with String");
        }
    };

    private CursorMatchers() {
    }

    private static int findColumnIndex(Matcher<String> matcher, Cursor cursor) {
        int n = -1;
        String[] stringArray = cursor.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!matcher.matches((Object)string)) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            n = -2;
            break;
        }
        return n;
    }

    public static CursorMatcher withRowShort(int n, short s) {
        return CursorMatchers.withRowShort(n, (Matcher<Short>)Matchers.is((Object)s));
    }

    public static CursorMatcher withRowShort(int n, Matcher<Short> matcher) {
        return new CursorMatcher(n, matcher, SHORT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowShort(String string, short s) {
        return CursorMatchers.withRowShort(string, (Matcher<Short>)Matchers.is((Object)s));
    }

    public static CursorMatcher withRowShort(String string, Matcher<Short> matcher) {
        return CursorMatchers.withRowShort((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowShort(Matcher<String> matcher, Matcher<Short> matcher2) {
        return new CursorMatcher(matcher, matcher2, SHORT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowInt(int n, int n2) {
        return CursorMatchers.withRowInt(n, (Matcher<Integer>)Matchers.is((Object)n2));
    }

    public static CursorMatcher withRowInt(int n, Matcher<Integer> matcher) {
        return new CursorMatcher(n, matcher, INT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowInt(String string, int n) {
        return CursorMatchers.withRowInt(string, (Matcher<Integer>)Matchers.is((Object)n));
    }

    public static CursorMatcher withRowInt(String string, Matcher<Integer> matcher) {
        return CursorMatchers.withRowInt((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowInt(Matcher<String> matcher, Matcher<Integer> matcher2) {
        return new CursorMatcher(matcher, matcher2, INT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowLong(int n, long l) {
        return CursorMatchers.withRowLong(n, (Matcher<Long>)Matchers.is((Object)l));
    }

    public static CursorMatcher withRowLong(int n, Matcher<Long> matcher) {
        return new CursorMatcher(n, matcher, LONG_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowLong(String string, long l) {
        return CursorMatchers.withRowLong(string, (Matcher<Long>)Matchers.is((Object)l));
    }

    public static CursorMatcher withRowLong(String string, Matcher<Long> matcher) {
        return CursorMatchers.withRowLong((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowLong(Matcher<String> matcher, Matcher<Long> matcher2) {
        return new CursorMatcher(matcher, matcher2, LONG_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowFloat(int n, float f) {
        return CursorMatchers.withRowFloat(n, (Matcher<Float>)Matchers.is((Object)Float.valueOf(f)));
    }

    public static CursorMatcher withRowFloat(int n, Matcher<Float> matcher) {
        return new CursorMatcher(n, matcher, FLOAT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowFloat(String string, float f) {
        return CursorMatchers.withRowFloat(string, (Matcher<Float>)Matchers.is((Object)Float.valueOf(f)));
    }

    public static CursorMatcher withRowFloat(String string, Matcher<Float> matcher) {
        return CursorMatchers.withRowFloat((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowFloat(Matcher<String> matcher, Matcher<Float> matcher2) {
        return new CursorMatcher(matcher, matcher2, FLOAT_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowDouble(int n, double d) {
        return CursorMatchers.withRowDouble(n, (Matcher<Double>)Matchers.is((Object)d));
    }

    public static CursorMatcher withRowDouble(int n, Matcher<Double> matcher) {
        return new CursorMatcher(n, matcher, DOUBLE_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowDouble(String string, double d) {
        return CursorMatchers.withRowDouble(string, (Matcher<Double>)Matchers.is((Object)d));
    }

    public static CursorMatcher withRowDouble(String string, Matcher<Double> matcher) {
        return CursorMatchers.withRowDouble((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowDouble(Matcher<String> matcher, Matcher<Double> matcher2) {
        return new CursorMatcher(matcher, matcher2, DOUBLE_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowString(int n, String string) {
        return CursorMatchers.withRowString(n, (Matcher<String>)Matchers.is((Object)string));
    }

    public static CursorMatcher withRowString(int n, Matcher<String> matcher) {
        return new CursorMatcher(n, matcher, STRING_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowString(String string, String string2) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)string), (Matcher<String>)Matchers.is((Object)string2));
    }

    public static CursorMatcher withRowString(String string, Matcher<String> matcher) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowString(Matcher<String> matcher, Matcher<String> matcher2) {
        return new CursorMatcher(matcher, matcher2, STRING_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowBlob(int n, byte[] byArray) {
        return CursorMatchers.withRowBlob(n, (Matcher<byte[]>)Matchers.is((Object)byArray));
    }

    public static CursorMatcher withRowBlob(int n, Matcher<byte[]> matcher) {
        return new CursorMatcher(n, matcher, BLOB_MATCHER_APPLIER);
    }

    public static CursorMatcher withRowBlob(String string, byte[] byArray) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)string), (Matcher<byte[]>)Matchers.is((Object)byArray));
    }

    public static CursorMatcher withRowBlob(String string, Matcher<byte[]> matcher) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowBlob(Matcher<String> matcher, Matcher<byte[]> matcher2) {
        return new CursorMatcher(matcher, matcher2, BLOB_MATCHER_APPLIER);
    }

    private static interface MatcherApplier
    extends SelfDescribing {
        public boolean apply(Cursor var1, int var2, Matcher<?> var3);
    }

    public static class CursorMatcher
    extends BoundedMatcher<Object, Cursor> {
        private final int columnIndex;
        private final Matcher<String> columnNameMatcher;
        private final Matcher<?> valueMatcher;
        private final MatcherApplier applier;
        private boolean checkColumns = true;

        private CursorMatcher(int n, Matcher<?> matcher, MatcherApplier matcherApplier) {
            super(Cursor.class);
            Preconditions.checkArgument(n >= 0);
            this.columnIndex = n;
            this.valueMatcher = Preconditions.checkNotNull(matcher);
            this.applier = Preconditions.checkNotNull(matcherApplier);
            this.columnNameMatcher = null;
        }

        private CursorMatcher(Matcher<String> matcher, Matcher<?> matcher2, MatcherApplier matcherApplier) {
            super(Cursor.class);
            this.columnNameMatcher = Preconditions.checkNotNull(matcher);
            this.valueMatcher = Preconditions.checkNotNull(matcher2);
            this.applier = Preconditions.checkNotNull(matcherApplier);
            this.columnIndex = -3;
        }

        @Override
        public boolean matchesSafely(Cursor cursor) {
            int n = this.columnIndex;
            if (n < 0 && (n = CursorMatchers.findColumnIndex((Matcher<String>)this.columnNameMatcher, cursor)) < 0) {
                StringDescription stringDescription = new StringDescription();
                this.columnNameMatcher.describeTo((Description)stringDescription);
                if (n == -1) {
                    if (this.checkColumns) {
                        String string = String.valueOf(Arrays.asList(cursor.getColumnNames()));
                        String string2 = stringDescription.toString();
                        throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Couldn't find column in ").append(string).append(" matching ").append(string2).toString());
                    }
                    return false;
                }
                if (n == -2) {
                    String string = String.valueOf(Arrays.asList(cursor.getColumnNames()));
                    String string3 = stringDescription.toString();
                    throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Multiple columns in ").append(string).append(" match ").append(string3).toString());
                }
                String string = String.valueOf(Arrays.asList(cursor.getColumnNames()));
                throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Couldn't find column in ").append(string).toString());
            }
            try {
                return this.applier.apply(cursor, n, this.valueMatcher);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                if (this.checkColumns) {
                    throw new IllegalArgumentException("Column index is invalid", cursorIndexOutOfBoundsException);
                }
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("Rows with column: ");
            if (this.columnIndex < 0) {
                this.columnNameMatcher.describeTo(description);
            } else {
                int n = this.columnIndex;
                description.appendText(new StringBuilder(21).append(" index = ").append(n).append(" ").toString());
            }
            this.applier.describeTo(description);
            description.appendText(" ");
            this.valueMatcher.describeTo(description);
        }

        public CursorMatcher withStrictColumnChecks(boolean bl) {
            this.checkColumns = bl;
            return this;
        }
    }
}

