/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable INTERRUPTING;
    private static final Runnable PARKED;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Throwable throwable;
        T t;
        boolean bl;
        Thread thread;
        block26: {
            thread = Thread.currentThread();
            if (!this.compareAndSet(null, thread)) {
                return;
            }
            bl = !this.isDone();
            t = null;
            throwable = null;
            try {
                if (!bl) break block26;
                t = this.runInterruptibly();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                }
                catch (Throwable throwable3) {
                    if (!this.compareAndSet(thread, DONE)) {
                        boolean bl2 = false;
                        int n = 0;
                        Runnable runnable = (Runnable)this.get();
                        while (runnable == INTERRUPTING || runnable == PARKED) {
                            if (++n > 1000) {
                                if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                    bl2 = Thread.interrupted() || bl2;
                                    LockSupport.park(this);
                                }
                            } else {
                                Thread.yield();
                            }
                            runnable = (Runnable)this.get();
                        }
                        if (bl2) {
                            thread.interrupt();
                        }
                    }
                    if (bl) {
                        this.afterRanInterruptibly(t, throwable);
                    }
                    throw throwable3;
                }
                if (!this.compareAndSet(thread, DONE)) {
                    boolean bl3 = false;
                    int n = 0;
                    Runnable runnable = (Runnable)this.get();
                    while (runnable == INTERRUPTING || runnable == PARKED) {
                        if (++n > 1000) {
                            if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                bl3 = Thread.interrupted() || bl3;
                                LockSupport.park(this);
                            }
                        } else {
                            Thread.yield();
                        }
                        runnable = (Runnable)this.get();
                    }
                    if (bl3) {
                        thread.interrupt();
                    }
                }
                if (bl) {
                    this.afterRanInterruptibly(t, throwable);
                }
            }
        }
        if (!this.compareAndSet(thread, DONE)) {
            boolean bl4 = false;
            int n = 0;
            Runnable runnable = (Runnable)this.get();
            while (runnable == INTERRUPTING || runnable == PARKED) {
                if (++n > 1000) {
                    if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                        bl4 = Thread.interrupted() || bl4;
                        LockSupport.park(this);
                    }
                } else {
                    Thread.yield();
                }
                runnable = (Runnable)this.get();
            }
            if (bl4) {
                thread.interrupt();
            }
        }
        if (bl) {
            this.afterRanInterruptibly(t, throwable);
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(T var1, Throwable var2);

    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (runnable instanceof Thread && this.compareAndSet(runnable, INTERRUPTING)) {
            try {
                ((Thread)runnable).interrupt();
            }
            finally {
                Runnable runnable2 = this.getAndSet(DONE);
                if (runnable2 == PARKED) {
                    LockSupport.unpark((Thread)runnable);
                }
            }
        }
    }

    @Override
    public final String toString() {
        String string;
        String string2;
        Runnable runnable = (Runnable)this.get();
        if (runnable == DONE) {
            string2 = "running=[DONE]";
        } else if (runnable == INTERRUPTING) {
            string2 = "running=[INTERRUPTED]";
        } else if (runnable instanceof Thread) {
            string = ((Thread)runnable).getName();
            string2 = new StringBuilder(21 + String.valueOf(string).length()).append("running=[RUNNING ON ").append(string).append("]").toString();
        } else {
            string2 = "running=[NOT STARTED YET]";
        }
        string = this.toPendingString();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(", ").append(string).toString();
    }

    abstract String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        INTERRUPTING = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

