/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    private final transient Object hashTable;
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, Object[] objectArray) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(objectArray[0], objectArray[1]);
            return new RegularImmutableMap<K, V>(null, objectArray, 1);
        }
        Preconditions.checkPositionIndex(n, objectArray.length >> 1);
        int n2 = ImmutableSet.chooseTableSize(n);
        Object object = RegularImmutableMap.createHashTable(objectArray, n, n2, 0);
        return new RegularImmutableMap<K, V>(object, objectArray, n);
    }

    static Object createHashTable(Object[] objectArray, int n, int n2, int n3) {
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(objectArray[n3], objectArray[n3 ^ 1]);
            return null;
        }
        int n4 = n2 - 1;
        if (n2 <= 128) {
            byte[] byArray = new byte[n2];
            Arrays.fill(byArray, (byte)-1);
            for (int i = 0; i < n; ++i) {
                int n5 = 2 * i + n3;
                Object object = objectArray[n5];
                Object object2 = objectArray[n5 ^ 1];
                CollectPreconditions.checkEntryNotNull(object, object2);
                int n6 = Hashing.smear(object.hashCode());
                while (true) {
                    int n7;
                    if ((n7 = byArray[n6 &= n4] & 0xFF) == 255) break;
                    if (objectArray[n7].equals(object)) {
                        throw RegularImmutableMap.duplicateKeyException(object, object2, objectArray, n7);
                    }
                    ++n6;
                }
                byArray[n6] = (byte)n5;
            }
            return byArray;
        }
        if (n2 <= 32768) {
            short[] sArray = new short[n2];
            Arrays.fill(sArray, (short)-1);
            for (int i = 0; i < n; ++i) {
                int n8 = 2 * i + n3;
                Object object = objectArray[n8];
                Object object3 = objectArray[n8 ^ 1];
                CollectPreconditions.checkEntryNotNull(object, object3);
                int n9 = Hashing.smear(object.hashCode());
                while (true) {
                    int n10;
                    if ((n10 = sArray[n9 &= n4] & 0xFFFF) == 65535) break;
                    if (objectArray[n10].equals(object)) {
                        throw RegularImmutableMap.duplicateKeyException(object, object3, objectArray, n10);
                    }
                    ++n9;
                }
                sArray[n9] = (short)n8;
            }
            return sArray;
        }
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < n; ++i) {
            int n11 = 2 * i + n3;
            Object object = objectArray[n11];
            Object object4 = objectArray[n11 ^ 1];
            CollectPreconditions.checkEntryNotNull(object, object4);
            int n12 = Hashing.smear(object.hashCode());
            while (true) {
                int n13;
                if ((n13 = nArray[n12 &= n4]) == -1) break;
                if (objectArray[n13].equals(object)) {
                    throw RegularImmutableMap.duplicateKeyException(object, object4, objectArray, n13);
                }
                ++n12;
            }
            nArray[n12] = n11;
        }
        return nArray;
    }

    private static IllegalArgumentException duplicateKeyException(Object object, Object object2, Object[] objectArray, int n) {
        String string = String.valueOf(object);
        String string2 = String.valueOf(object2);
        String string3 = String.valueOf(objectArray[n]);
        String string4 = String.valueOf(objectArray[n ^ 1]);
        return new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Multiple entries with same key: ").append(string).append("=").append(string2).append(" and ").append(string3).append("=").append(string4).toString());
    }

    private RegularImmutableMap(Object object, Object[] objectArray, int n) {
        this.hashTable = object;
        this.alternatingKeysAndValues = objectArray;
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object object) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, object);
    }

    static Object get(Object object, Object[] objectArray, int n, int n2, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (n == 1) {
            return objectArray[n2].equals(object2) ? objectArray[n2 ^ 1] : null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n3 = byArray.length - 1;
            int n4 = Hashing.smear(object2.hashCode());
            while (true) {
                int n5;
                if ((n5 = byArray[n4 &= n3] & 0xFF) == 255) {
                    return null;
                }
                if (objectArray[n5].equals(object2)) {
                    return objectArray[n5 ^ 1];
                }
                ++n4;
            }
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n6 = sArray.length - 1;
            int n7 = Hashing.smear(object2.hashCode());
            while (true) {
                int n8;
                if ((n8 = sArray[n7 &= n6] & 0xFFFF) == 65535) {
                    return null;
                }
                if (objectArray[n8].equals(object2)) {
                    return objectArray[n8 ^ 1];
                }
                ++n7;
            }
        }
        int[] nArray = (int[])object;
        int n9 = nArray.length - 1;
        int n10 = Hashing.smear(object2.hashCode());
        int n11;
        while ((n11 = nArray[n10 &= n9]) != -1) {
            if (objectArray[n11].equals(object2)) {
                return objectArray[n11 ^ 1];
            }
            ++n10;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keysOrValuesAsList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> immutableMap, ImmutableList<K> immutableList) {
            this.map = immutableMap;
            this.list = immutableList;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.get(object) != null;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] objectArray, int n, int n2) {
            this.alternatingKeysAndValues = objectArray;
            this.offset = n;
            this.size = n2;
        }

        @Override
        public Object get(int n) {
            Preconditions.checkElementIndex(n, this.size);
            return this.alternatingKeysAndValues[2 * n + this.offset];
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> immutableMap, Object[] objectArray, int n, int n2) {
            this.map = immutableMap;
            this.alternatingKeysAndValues = objectArray;
            this.keyOffset = n;
            this.size = n2;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int n) {
                    Preconditions.checkElementIndex(n, EntrySet.this.size);
                    Object object = EntrySet.this.alternatingKeysAndValues[2 * n + EntrySet.this.keyOffset];
                    Object object2 = EntrySet.this.alternatingKeysAndValues[2 * n + (EntrySet.this.keyOffset ^ 1)];
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
                }

                @Override
                public int size() {
                    return EntrySet.this.size;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

