/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import androidx.test.espresso.Root;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

final class RootsOracle
implements ActiveRootLister {
    private static final String TAG = RootsOracle.class.getSimpleName();
    private static final String WINDOW_MANAGER_IMPL_CLAZZ = "android.view.WindowManagerImpl";
    private static final String WINDOW_MANAGER_GLOBAL_CLAZZ = "android.view.WindowManagerGlobal";
    private static final String VIEWS_FIELD = "mViews";
    private static final String WINDOW_PARAMS_FIELD = "mParams";
    private static final String GET_DEFAULT_IMPL = "getDefault";
    private static final String GET_GLOBAL_INSTANCE = "getInstance";
    private final Looper mainLooper;
    private boolean initialized;
    private Object windowManagerObj;
    private Field viewsField;
    private Field paramsField;

    RootsOracle(Looper looper) {
        this.mainLooper = looper;
    }

    @Override
    public List<Root> listActiveRoots() {
        Preconditions.checkState(this.mainLooper.equals(Looper.myLooper()), "must be called on main thread.");
        if (!this.initialized) {
            this.initialize();
        }
        if (null == this.windowManagerObj) {
            Log.w((String)TAG, (String)"No reflective access to windowmanager object.");
            return Lists.newArrayList();
        }
        if (null == this.viewsField) {
            Log.w((String)TAG, (String)"No reflective access to mViews");
            return Lists.newArrayList();
        }
        if (null == this.paramsField) {
            Log.w((String)TAG, (String)"No reflective access to mParams");
            return Lists.newArrayList();
        }
        List<View> list = null;
        List<WindowManager.LayoutParams> list2 = null;
        try {
            if (Build.VERSION.SDK_INT < 19) {
                list = Arrays.asList((View[])this.viewsField.get(this.windowManagerObj));
                list2 = Arrays.asList((WindowManager.LayoutParams[])this.paramsField.get(this.windowManagerObj));
            } else {
                list = (List<View>)this.viewsField.get(this.windowManagerObj);
                list2 = (List<WindowManager.LayoutParams>)this.paramsField.get(this.windowManagerObj);
            }
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)String.format(Locale.ROOT, "Reflective access to %s or %s on %s failed.", this.viewsField, this.paramsField, this.windowManagerObj), (Throwable)runtimeException);
            return Lists.newArrayList();
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (String)String.format(Locale.ROOT, "Reflective access to %s or %s on %s failed.", this.viewsField, this.paramsField, this.windowManagerObj), (Throwable)illegalAccessException);
            return Lists.newArrayList();
        }
        ArrayList<Root> arrayList = Lists.newArrayList();
        for (int i = list.size() - 1; i > -1; --i) {
            arrayList.add(new Root.Builder().withDecorView(list.get(i)).withWindowLayoutParams(list2.get(i)).build());
        }
        return arrayList;
    }

    private void initialize() {
        this.initialized = true;
        String string = Build.VERSION.SDK_INT > 16 ? WINDOW_MANAGER_GLOBAL_CLAZZ : WINDOW_MANAGER_IMPL_CLAZZ;
        String string2 = Build.VERSION.SDK_INT > 16 ? GET_GLOBAL_INSTANCE : GET_DEFAULT_IMPL;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, new Class[0]);
            this.windowManagerObj = method.invoke(null, new Object[0]);
            this.viewsField = clazz.getDeclaredField(VIEWS_FIELD);
            this.viewsField.setAccessible(true);
            this.paramsField = clazz.getDeclaredField(WINDOW_PARAMS_FIELD);
            this.paramsField.setAccessible(true);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "could not invoke: %s on %s", string2, string), (Throwable)invocationTargetException.getCause());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "could not find class: %s", string), (Throwable)classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "could not find field: %s or %s on %s", WINDOW_PARAMS_FIELD, VIEWS_FIELD, string), (Throwable)noSuchFieldException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "could not find method: %s on %s", string2, string), (Throwable)noSuchMethodException);
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "reflective setup failed using obj: %s method: %s field: %s", string, string2, VIEWS_FIELD), (Throwable)runtimeException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "reflective setup failed using obj: %s method: %s field: %s", string, string2, VIEWS_FIELD), (Throwable)illegalAccessException);
        }
    }
}

