/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class AsyncTaskPoolMonitor {
    private final AtomicReference<IdleMonitor> monitor = new AtomicReference<Object>(null);
    private final ThreadPoolExecutor pool;
    private final AtomicInteger activeBarrierChecks = new AtomicInteger(0);

    AsyncTaskPoolMonitor(ThreadPoolExecutor threadPoolExecutor) {
        this.pool = Preconditions.checkNotNull(threadPoolExecutor);
    }

    IdleNotifier<Runnable> asIdleNotifier() {
        return new IdleNotifier<Runnable>(){

            @Override
            public boolean isIdleNow() {
                return AsyncTaskPoolMonitor.this.isIdleNow();
            }

            @Override
            public void cancelCallback() {
                AsyncTaskPoolMonitor.this.cancelIdleMonitor();
            }

            @Override
            public void registerNotificationCallback(Runnable runnable) {
                AsyncTaskPoolMonitor.this.notifyWhenIdle(runnable);
            }
        };
    }

    boolean isIdleNow() {
        if (!this.pool.getQueue().isEmpty()) {
            return false;
        }
        int n = this.pool.getActiveCount();
        if (0 != n && this.monitor.get() == null) {
            n -= this.activeBarrierChecks.get();
        }
        return 0 == n;
    }

    void notifyWhenIdle(Runnable runnable) {
        Preconditions.checkNotNull(runnable);
        IdleMonitor idleMonitor = new IdleMonitor(runnable);
        Preconditions.checkState(this.monitor.compareAndSet(null, idleMonitor), "cannot monitor for idle recursively!");
        idleMonitor.monitorForIdle();
    }

    void cancelIdleMonitor() {
        IdleMonitor idleMonitor = this.monitor.getAndSet(null);
        if (null != idleMonitor) {
            idleMonitor.poison();
        }
    }

    private static class BarrierRestarter {
        private final CyclicBarrier barrier;
        private final AtomicInteger barrierGeneration;

        BarrierRestarter(CyclicBarrier cyclicBarrier, AtomicInteger atomicInteger) {
            this.barrier = cyclicBarrier;
            this.barrierGeneration = atomicInteger;
        }

        synchronized void restart(int n) {
            int n2 = n + 1;
            if (this.barrierGeneration.compareAndSet(n, n2)) {
                this.barrier.reset();
            }
        }
    }

    private class IdleMonitor {
        private final Runnable onIdle;
        private final AtomicInteger barrierGeneration = new AtomicInteger(0);
        private final CyclicBarrier barrier;
        private volatile boolean poisoned;

        private IdleMonitor(final Runnable runnable) {
            this.onIdle = Preconditions.checkNotNull(runnable);
            this.barrier = new CyclicBarrier(AsyncTaskPoolMonitor.this.pool.getCorePoolSize(), new Runnable(){

                @Override
                public void run() {
                    if (AsyncTaskPoolMonitor.this.pool.getQueue().isEmpty()) {
                        AsyncTaskPoolMonitor.this.monitor.compareAndSet(IdleMonitor.this, null);
                        runnable.run();
                    } else {
                        IdleMonitor.this.monitorForIdle();
                    }
                }
            });
        }

        private void poison() {
            this.poisoned = true;
            this.barrier.reset();
        }

        private void monitorForIdle() {
            if (this.poisoned) {
                return;
            }
            if (AsyncTaskPoolMonitor.this.isIdleNow()) {
                AsyncTaskPoolMonitor.this.monitor.compareAndSet(this, null);
                this.onIdle.run();
            } else {
                int n = AsyncTaskPoolMonitor.this.pool.getCorePoolSize();
                final BarrierRestarter barrierRestarter = new BarrierRestarter(this.barrier, this.barrierGeneration);
                for (int i = 0; i < n; ++i) {
                    AsyncTaskPoolMonitor.this.pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            while (!IdleMonitor.this.poisoned) {
                                AsyncTaskPoolMonitor.this.activeBarrierChecks.incrementAndGet();
                                int n = IdleMonitor.this.barrierGeneration.get();
                                try {
                                    IdleMonitor.this.barrier.await();
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    barrierRestarter.restart(n);
                                }
                                catch (BrokenBarrierException brokenBarrierException) {
                                    barrierRestarter.restart(n);
                                }
                                finally {
                                    AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

