/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewAssertions {
    private static final String TAG = ViewAssertions.class.getSimpleName();

    private ViewAssertions() {
    }

    public static ViewAssertion doesNotExist() {
        return new DoesNotExistViewAssertion();
    }

    public static ViewAssertion matches(Matcher<? super View> matcher) {
        return new MatchesViewAssertion(Preconditions.checkNotNull(matcher));
    }

    public static ViewAssertion selectedDescendantsMatch(Matcher<View> matcher, Matcher<View> matcher2) {
        return new SelectedDescendantsMatchViewAssertion(matcher, matcher2);
    }

    static class SelectedDescendantsMatchViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;
        @RemoteMsgField(order=1)
        private final Matcher<View> matcher;

        @RemoteMsgConstructor
        private SelectedDescendantsMatchViewAssertion(Matcher<View> matcher, Matcher<View> matcher2) {
            this.selector = matcher;
            this.matcher = matcher2;
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            Object object;
            Preconditions.checkNotNull(view);
            Predicate<View> predicate = new Predicate<View>(){

                @Override
                public boolean apply(View view) {
                    return SelectedDescendantsMatchViewAssertion.this.selector.matches((Object)view);
                }
            };
            Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
            ArrayList<View> arrayList = new ArrayList<View>();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (this.matcher.matches(object)) continue;
                arrayList.add((View)object);
            }
            if (arrayList.size() > 0) {
                object = HumanReadables.getViewHierarchyErrorMessage(view, arrayList, String.format(Locale.ROOT, "At least one view did not match the required matcher: %s", this.matcher), "****DOES NOT MATCH****");
                throw new AssertionFailedError((String)object);
            }
        }

        public String toString() {
            return String.format(Locale.ROOT, "SelectedDescendantsMatchViewAssertion{selector=%s, matcher=%s}", this.selector, this.matcher);
        }
    }

    static class DoesNotExistViewAssertion
    implements ViewAssertion {
        @RemoteMsgConstructor
        private DoesNotExistViewAssertion() {
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            if (view != null) {
                String string = String.valueOf(HumanReadables.describe(view));
                ViewMatchers.assertThat(string.length() != 0 ? "View is present in the hierarchy: ".concat(string) : new String("View is present in the hierarchy: "), true, Matchers.is((Object)false));
            }
        }
    }

    static class MatchesViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        final Matcher<? super View> viewMatcher;

        @RemoteMsgConstructor
        private MatchesViewAssertion(Matcher<? super View> matcher) {
            this.viewMatcher = matcher;
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            StringDescription stringDescription = new StringDescription();
            stringDescription.appendText("'");
            this.viewMatcher.describeTo((Description)stringDescription);
            if (noMatchingViewException != null) {
                stringDescription.appendText(String.format(Locale.ROOT, "' check could not be performed because view '%s' was not found.\n", noMatchingViewException.getViewMatcherDescription()));
                Log.e((String)TAG, (String)stringDescription.toString());
                throw noMatchingViewException;
            }
            stringDescription.appendText("' doesn't match the selected view.");
            ViewMatchers.assertThat(stringDescription.toString(), view, this.viewMatcher);
        }

        public String toString() {
            return String.format(Locale.ROOT, "MatchesViewAssertion{viewMatcher=%s}", this.viewMatcher);
        }
    }
}

