/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.SearchView;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TypeTextAction
implements ViewAction {
    private static final String TAG = TypeTextAction.class.getSimpleName();
    @RemoteMsgField(order=0)
    final String stringToBeTyped;
    @RemoteMsgField(order=1)
    final boolean tapToFocus;

    public TypeTextAction(String string) {
        this(string, true);
    }

    @RemoteMsgConstructor
    public TypeTextAction(String string, boolean bl) {
        Preconditions.checkNotNull(string);
        this.stringToBeTyped = string;
        this.tapToFocus = bl;
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{ViewMatchers.isDisplayed()});
        if (!this.tapToFocus) {
            matcher = Matchers.allOf((Matcher)matcher, ViewMatchers.hasFocus());
        }
        if (Build.VERSION.SDK_INT < 11) {
            return Matchers.allOf((Matcher)matcher, ViewMatchers.supportsInputMethods());
        }
        return Matchers.allOf((Matcher)matcher, (Matcher)Matchers.anyOf(ViewMatchers.supportsInputMethods(), ViewMatchers.isAssignableFrom(SearchView.class)));
    }

    @Override
    public void perform(UiController uiController, View view) {
        if (this.stringToBeTyped.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return;
        }
        if (this.tapToFocus) {
            new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER).perform(uiController, view);
            uiController.loopMainThreadUntilIdle();
        }
        try {
            if (!uiController.injectString(this.stringToBeTyped)) {
                String string = String.valueOf(this.stringToBeTyped);
                Log.e((String)TAG, (String)(string.length() != 0 ? "Failed to type text: ".concat(string) : new String("Failed to type text: ")));
                String string2 = String.valueOf(this.stringToBeTyped);
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(string2.length() != 0 ? "Failed to type text: ".concat(string2) : new String("Failed to type text: "))).build();
            }
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            String string = String.valueOf(this.stringToBeTyped);
            Log.e((String)TAG, (String)(string.length() != 0 ? "Failed to type text: ".concat(string) : new String("Failed to type text: ")));
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }

    @Override
    public String getDescription() {
        return String.format(Locale.ROOT, "type text(%s)", this.stringToBeTyped);
    }
}

