/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Locale;

public final class MotionEvents {
    private static final String TAG = MotionEvents.class.getSimpleName();
    static final int MAX_CLICK_ATTEMPTS = 3;

    private MotionEvents() {
    }

    public static DownResultHolder sendDown(UiController uiController, float[] fArray, float[] fArray2) {
        return MotionEvents.sendDown(uiController, fArray, fArray2, 0, 1);
    }

    public static MotionEvent obtainDownEvent(float[] fArray, float[] fArray2, int n, int n2) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        long l = SystemClock.uptimeMillis();
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.downPressGingerBread(l, fArray, fArray2);
        }
        return MotionEvents.downPressICS(l, fArray, fArray2, n, n2);
    }

    public static MotionEvent obtainDownEvent(float[] fArray, float[] fArray2) {
        return MotionEvents.obtainDownEvent(fArray, fArray2, 0, 1);
    }

    public static DownResultHolder sendDown(UiController uiController, float[] fArray, float[] fArray2, int n, int n2) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        for (int i = 0; i < 3; ++i) {
            MotionEvent motionEvent = null;
            try {
                long l;
                motionEvent = MotionEvents.obtainDownEvent(fArray, fArray2, n, n2);
                long l2 = motionEvent.getDownTime();
                long l3 = l2 + (long)(ViewConfiguration.getTapTimeout() / 2);
                boolean bl = uiController.injectMotionEvent(motionEvent);
                while ((l = l3 - SystemClock.uptimeMillis()) > 10L) {
                    uiController.loopMainThreadForAtLeast(l / 4L);
                }
                boolean bl2 = false;
                if (SystemClock.uptimeMillis() > l2 + (long)ViewConfiguration.getLongPressTimeout()) {
                    bl2 = true;
                    Log.w((String)TAG, (String)"Overslept and turned a tap into a long press");
                }
                if (bl) {
                    return new DownResultHolder(motionEvent, bl2);
                }
                motionEvent.recycle();
                motionEvent = null;
                continue;
            }
            catch (InjectEventSecurityException injectEventSecurityException) {
                throw new PerformException.Builder().withActionDescription("Send down motion event").withViewDescription("unknown").withCause((Throwable)((Object)injectEventSecurityException)).build();
            }
        }
        throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "click (after %s attempts)", 3)).withViewDescription("unknown").build();
    }

    public static boolean sendUp(UiController uiController, MotionEvent motionEvent) {
        return MotionEvents.sendUp(uiController, motionEvent, new float[]{motionEvent.getX(), motionEvent.getY()});
    }

    public static MotionEvent obtainUpEvent(MotionEvent motionEvent, float[] fArray) {
        Preconditions.checkNotNull(motionEvent);
        Preconditions.checkNotNull(fArray);
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.upPressGingerBread(motionEvent, fArray);
        }
        return MotionEvents.upPressICS(motionEvent, fArray);
    }

    public static boolean sendUp(UiController uiController, MotionEvent motionEvent, float[] fArray) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(motionEvent);
        Preconditions.checkNotNull(fArray);
        MotionEvent motionEvent2 = null;
        try {
            motionEvent2 = MotionEvents.obtainUpEvent(motionEvent, fArray);
            boolean bl = uiController.injectMotionEvent(motionEvent2);
            if (!bl) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of up event failed (corresponding down event: %s)", motionEvent));
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject up event (corresponding down event: %s)", motionEvent)).withViewDescription("unknown").withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
        finally {
            if (null != motionEvent2) {
                motionEvent2.recycle();
                motionEvent2 = null;
            }
        }
        return true;
    }

    public static void sendCancel(UiController uiController, MotionEvent motionEvent) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(motionEvent);
        MotionEvent motionEvent2 = null;
        try {
            motionEvent2 = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)3, (float)motionEvent.getX(), (float)motionEvent.getY(), (int)0);
            boolean bl = uiController.injectMotionEvent(motionEvent2);
            if (!bl) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of cancel event failed (corresponding down event: %s)", motionEvent));
                return;
            }
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject cancel event (corresponding down event: %s)", motionEvent)).withViewDescription("unknown").withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
        finally {
            if (null != motionEvent2) {
                motionEvent2.recycle();
                motionEvent2 = null;
            }
        }
    }

    public static MotionEvent obtainMovement(long l, float[] fArray) {
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)2, (float)fArray[0], (float)fArray[1], (int)0);
    }

    public static MotionEvent obtainMovement(long l, long l2, float[] fArray) {
        return MotionEvent.obtain((long)l, (long)l2, (int)2, (float)fArray[0], (float)fArray[1], (int)0);
    }

    public static boolean sendMovement(UiController uiController, MotionEvent motionEvent, float[] fArray) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(motionEvent);
        Preconditions.checkNotNull(fArray);
        MotionEvent motionEvent2 = null;
        try {
            motionEvent2 = MotionEvents.obtainMovement(motionEvent.getDownTime(), fArray);
            boolean bl = uiController.injectMotionEvent(motionEvent2);
            if (!bl) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of motion event failed (corresponding down event: %s)", motionEvent));
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject motion event (corresponding down event: %s)", motionEvent)).withViewDescription("unknown").withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
        finally {
            if (null != motionEvent2) {
                motionEvent2.recycle();
                motionEvent2 = null;
            }
        }
        return true;
    }

    private static MotionEvent downPressGingerBread(long l, float[] fArray, float[] fArray2) {
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)0, (float)fArray[0], (float)fArray[1], (float)0.0f, (float)1.0f, (int)0, (float)fArray2[0], (float)fArray2[1], (int)0, (int)0);
    }

    private static MotionEvent downPressICS(long l, float[] fArray, float[] fArray2, int n, int n2) {
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
        MotionEvent.PointerProperties[] pointerPropertiesArray = MotionEvents.getPointerProperties(n);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = fArray[0];
        pointerCoordsArray[0].y = fArray[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)0, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)n2, (float)fArray2[0], (float)fArray2[1], (int)0, (int)0, (int)n, (int)0);
    }

    private static MotionEvent upPressGingerBread(MotionEvent motionEvent, float[] fArray) {
        return MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (float)fArray[0], (float)fArray[1], (int)0);
    }

    private static MotionEvent upPressICS(MotionEvent motionEvent, float[] fArray) {
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
        MotionEvent.PointerProperties[] pointerPropertiesArray = MotionEvents.getPointerProperties(motionEvent.getSource());
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = fArray[0];
        pointerCoordsArray[0].y = fArray[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)motionEvent.getButtonState(), (float)motionEvent.getXPrecision(), (float)motionEvent.getYPrecision(), (int)0, (int)0, (int)motionEvent.getSource(), (int)0);
    }

    private static MotionEvent.PointerProperties[] getPointerProperties(int n) {
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
        pointerPropertiesArray[0].clear();
        pointerPropertiesArray[0].id = 0;
        switch (n) {
            case 8194: {
                pointerPropertiesArray[0].toolType = 3;
                break;
            }
            case 16386: {
                pointerPropertiesArray[0].toolType = 2;
                break;
            }
            case 4098: {
                pointerPropertiesArray[0].toolType = 1;
                break;
            }
            default: {
                pointerPropertiesArray[0].toolType = 0;
            }
        }
        return pointerPropertiesArray;
    }

    public static class DownResultHolder {
        public final MotionEvent down;
        public final boolean longPress;

        DownResultHolder(MotionEvent motionEvent, boolean bl) {
            this.down = motionEvent;
            this.longPress = bl;
        }
    }
}

