/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.ActivityLifecycles;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.Locale;
import org.hamcrest.Matcher;

class KeyEventActionBase
implements ViewAction {
    private static final String TAG = "KeyEventActionBase";
    public static final int BACK_ACTIVITY_TRANSITION_MILLIS_DELAY = 150;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_ATTEMPTS = 4;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_MILLIS_DELAY = 150;
    final EspressoKey espressoKey;

    KeyEventActionBase(EspressoKey espressoKey) {
        this.espressoKey = Preconditions.checkNotNull(espressoKey);
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayed();
    }

    @Override
    public String getDescription() {
        return String.format(Locale.ROOT, "send %s key event", this.espressoKey);
    }

    @Override
    public void perform(UiController uiController, View view) {
        try {
            if (!this.sendKeyEvent(uiController)) {
                String string = String.valueOf(this.espressoKey);
                Log.e((String)TAG, (String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to inject espressoKey event: ").append(string).toString());
                string = String.valueOf(this.espressoKey);
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(new StringBuilder(35 + String.valueOf(string).length()).append("Failed to inject espressoKey event ").append(string).toString())).build();
            }
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            String string = String.valueOf(this.espressoKey);
            Log.e((String)TAG, (String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to inject espressoKey event: ").append(string).toString());
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }

    private boolean sendKeyEvent(UiController uiController) throws InjectEventSecurityException {
        int n;
        boolean bl = false;
        long l = SystemClock.uptimeMillis();
        for (n = 0; !bl && n < 4; ++n) {
            bl = uiController.injectKeyEvent(new KeyEvent(l, l, 0, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState()));
        }
        if (!bl) {
            return false;
        }
        bl = false;
        l = SystemClock.uptimeMillis();
        for (n = 0; !bl && n < 4; ++n) {
            bl = uiController.injectKeyEvent(new KeyEvent(l, l, 1, this.espressoKey.getKeyCode(), 0));
        }
        return bl;
    }

    static Activity getCurrentActivity() {
        Collection collection = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        return (Activity)Iterables.getOnlyElement(collection);
    }

    static void waitForStageChangeInitialActivity(UiController uiController, Activity activity) {
        if (KeyEventActionBase.isActivityResumed(activity)) {
            uiController.loopMainThreadForAtLeast(150L);
            if (KeyEventActionBase.isActivityResumed(activity)) {
                Log.e((String)TAG, (String)"Back was pressed but there was no Activity stage transition in 150ms, possibly due to a delay calling super.onBackPressed() from your Activity.");
            }
        }
    }

    private static boolean isActivityResumed(Activity activity) {
        return ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity) == Stage.RESUMED;
    }

    static void waitForPendingForegroundActivities(UiController uiController, boolean bl) {
        ActivityLifecycleMonitor activityLifecycleMonitor = ActivityLifecycleMonitorRegistry.getInstance();
        boolean bl2 = false;
        for (int i = 0; i < 4; ++i) {
            uiController.loopMainThreadUntilIdle();
            bl2 = ActivityLifecycles.hasTransitioningActivities(activityLifecycleMonitor);
            if (!bl2) break;
            uiController.loopMainThreadForAtLeast(150L);
        }
        if (!ActivityLifecycles.hasForegroundActivities(activityLifecycleMonitor)) {
            if (bl) {
                throw new NoActivityResumedException("Pressed back and killed the app");
            }
            Log.w((String)TAG, (String)"Pressed back and hopped to a different process or potentially killed the app");
        }
        if (bl2) {
            Log.e((String)TAG, (String)"Back was pressed and left the application in an inconsistent state even after 600ms.");
        }
    }
}

