/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class GeneralSwipeAction
implements ViewAction {
    private static final int MAX_TRIES = 3;
    private static final int VIEW_DISPLAY_PERCENTAGE = 90;
    final CoordinatesProvider startCoordinatesProvider;
    final CoordinatesProvider endCoordinatesProvider;
    final Swiper swiper;
    final PrecisionDescriber precisionDescriber;

    public GeneralSwipeAction(Swiper swiper, CoordinatesProvider coordinatesProvider, CoordinatesProvider coordinatesProvider2, PrecisionDescriber precisionDescriber) {
        this.swiper = swiper;
        this.startCoordinatesProvider = coordinatesProvider;
        this.endCoordinatesProvider = coordinatesProvider2;
        this.precisionDescriber = precisionDescriber;
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayingAtLeast(90);
    }

    @Override
    public void perform(UiController uiController, View view) {
        float[] fArray = this.startCoordinatesProvider.calculateCoordinates(view);
        float[] fArray2 = this.endCoordinatesProvider.calculateCoordinates(view);
        float[] fArray3 = this.precisionDescriber.describePrecision();
        Swiper.Status status = Swiper.Status.FAILURE;
        for (int i = 0; i < 3 && status != Swiper.Status.SUCCESS; ++i) {
            try {
                status = this.swiper.sendSwipe(uiController, fArray, fArray2, fArray3);
            }
            catch (RuntimeException runtimeException) {
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(runtimeException).build();
            }
            int n = ViewConfiguration.getPressedStateDuration();
            if (n <= 0) continue;
            uiController.loopMainThreadForAtLeast(n);
        }
        if (status == Swiper.Status.FAILURE) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Couldn't swipe from: %s,%s to: %s,%s precision: %s, %s . Swiper: %s start coordinate provider: %s precision describer: %s. Tried %s times", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray3[0]), Float.valueOf(fArray3[1]), this.swiper, this.startCoordinatesProvider, this.precisionDescriber, 3))).build();
        }
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.swiper.toString().toLowerCase()).concat(" swipe");
    }
}

