/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class EditorAction
implements ViewAction {
    @RemoteMsgConstructor
    public EditorAction() {
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayed();
    }

    @Override
    public String getDescription() {
        return "input method editor";
    }

    @Override
    public void perform(UiController uiController, View view) {
        int n;
        EditorInfo editorInfo = new EditorInfo();
        InputConnection inputConnection = view.onCreateInputConnection(editorInfo);
        if (inputConnection == null) {
            throw new PerformException.Builder().withActionDescription(this.toString()).withViewDescription(HumanReadables.describe(view)).withCause(new IllegalStateException("View does not support input methods")).build();
        }
        int n2 = n = editorInfo.actionId != 0 ? editorInfo.actionId : editorInfo.imeOptions & 0xFF;
        if (n == 1) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new IllegalStateException("No available action on view")).build();
        }
        if (!inputConnection.performEditorAction(n)) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Failed to perform action %#x. Input connection no longer valid", n))).build();
        }
    }
}

