/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.ArrayList;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class AdapterDataLoaderAction
implements ViewAction {
    final Matcher<? extends Object> dataToLoadMatcher;
    final EspressoOptional<Integer> atPosition;
    final AdapterViewProtocol adapterViewProtocol;
    private AdapterViewProtocol.AdaptedData adaptedData;
    private boolean performed = false;
    private final Object dataLock = new Object();

    public AdapterDataLoaderAction(Matcher<? extends Object> matcher, EspressoOptional<Integer> espressoOptional, AdapterViewProtocol adapterViewProtocol) {
        this.dataToLoadMatcher = Preconditions.checkNotNull(matcher);
        this.atPosition = Preconditions.checkNotNull(espressoOptional);
        this.adapterViewProtocol = Preconditions.checkNotNull(adapterViewProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdapterViewProtocol.AdaptedData getAdaptedData() {
        Object object = this.dataLock;
        synchronized (object) {
            Preconditions.checkState(this.performed, "perform hasn't beenViewFinderImpl called yet!");
            return this.adaptedData;
        }
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.isAssignableFrom(AdapterView.class), ViewMatchers.isDisplayed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(UiController uiController, View view) {
        Object object;
        AdapterView adapterView = (AdapterView)view;
        ArrayList<AdapterViewProtocol.AdaptedData> arrayList = Lists.newArrayList();
        for (AdapterViewProtocol.AdaptedData object22 : this.adapterViewProtocol.getDataInAdapterView((AdapterView<? extends Adapter>)adapterView)) {
            if (!this.dataToLoadMatcher.matches(object22.getData())) continue;
            arrayList.add(object22);
        }
        if (arrayList.size() == 0) {
            object = new StringDescription();
            this.dataToLoadMatcher.describeTo((Description)object);
            if (arrayList.isEmpty()) {
                object.appendText(" contained values: ");
                object.appendValue(this.adapterViewProtocol.getDataInAdapterView((AdapterView<? extends Adapter>)adapterView));
                String n = String.valueOf(object);
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(new StringBuilder(24 + String.valueOf(n).length()).append("No data found matching: ").append(n).toString())).build();
            }
        }
        object = this.dataLock;
        synchronized (object) {
            Preconditions.checkState(!this.performed, "perform called 2x!");
            this.performed = true;
            if (this.atPosition.isPresent()) {
                int n = arrayList.size() - 1;
                if (this.atPosition.get() > n) {
                    throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "There are only %d elements that matched but requested %d element.", n, this.atPosition.get()))).build();
                }
                this.adaptedData = (AdapterViewProtocol.AdaptedData)arrayList.get(this.atPosition.get());
            } else {
                if (arrayList.size() != 1) {
                    StringDescription stringDescription = new StringDescription();
                    this.dataToLoadMatcher.describeTo((Description)stringDescription);
                    String string = String.valueOf(stringDescription);
                    String string2 = String.valueOf(arrayList);
                    throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Multiple data elements matched: ").append(string).append(". Elements: ").append(string2).toString())).build();
                }
                this.adaptedData = (AdapterViewProtocol.AdaptedData)arrayList.get(0);
            }
        }
        int n = 0;
        while (!this.adapterViewProtocol.isDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData)) {
            if (n > 1) {
                if (n % 50 == 0) {
                    adapterView.invalidate();
                    this.adapterViewProtocol.makeDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData);
                }
            } else {
                this.adapterViewProtocol.makeDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData);
            }
            uiController.loopMainThreadForAtLeast(100L);
            ++n;
        }
    }

    @Override
    public String getDescription() {
        return "load adapter data";
    }
}

