/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.remote.RemoteInteractionRegistry;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;

class ViewInteractionModule {
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcher = new AtomicReference<Matcher<Root>>(RootMatchers.DEFAULT);
    private final AtomicReference<Boolean> needsActivity = new AtomicReference<Boolean>(true);

    ViewInteractionModule(Matcher<View> matcher) {
        this.viewMatcher = Preconditions.checkNotNull(matcher);
    }

    RemoteInteraction provideRemoteInteraction() {
        return RemoteInteractionRegistry.getInstance();
    }

    AtomicReference<Boolean> provideNeedsActivity() {
        return this.needsActivity;
    }

    AtomicReference<Matcher<Root>> provideRootMatcher() {
        return this.rootMatcher;
    }

    Matcher<View> provideViewMatcher() {
        return this.viewMatcher;
    }

    ViewFinder provideViewFinder(ViewFinderImpl viewFinderImpl) {
        return viewFinderImpl;
    }

    public View provideRootView(RootViewPicker rootViewPicker) {
        return rootViewPicker.get();
    }
}

