/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.InteractionResultsHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewInteraction {
    private static final String TAG = ViewInteraction.class.getSimpleName();
    private final InterruptableUiController uiController;
    private final ViewFinder viewFinder;
    private final Executor mainThreadExecutor;
    private final ControlledLooper controlledLooper;
    private volatile FailureHandler failureHandler;
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcherRef;
    private final AtomicReference<Boolean> needsActivity;
    private final RemoteInteraction remoteInteraction;
    private final ListeningExecutorService remoteExecutor;
    private boolean hasRootMatcher = false;

    ViewInteraction(UiController uiController, ViewFinder viewFinder, @MainThread Executor executor, FailureHandler failureHandler, Matcher<View> matcher, AtomicReference<Matcher<Root>> atomicReference, AtomicReference<Boolean> atomicReference2, RemoteInteraction remoteInteraction, ListeningExecutorService listeningExecutorService, ControlledLooper controlledLooper) {
        this.viewFinder = Preconditions.checkNotNull(viewFinder);
        this.uiController = (InterruptableUiController)Preconditions.checkNotNull(uiController);
        this.failureHandler = Preconditions.checkNotNull(failureHandler);
        this.mainThreadExecutor = Preconditions.checkNotNull(executor);
        this.viewMatcher = Preconditions.checkNotNull(matcher);
        this.rootMatcherRef = Preconditions.checkNotNull(atomicReference);
        this.needsActivity = Preconditions.checkNotNull(atomicReference2);
        this.remoteInteraction = Preconditions.checkNotNull(remoteInteraction);
        this.remoteExecutor = Preconditions.checkNotNull(listeningExecutorService);
        this.controlledLooper = Preconditions.checkNotNull(controlledLooper);
    }

    public ViewInteraction perform(ViewAction ... viewActionArray) {
        Preconditions.checkNotNull(viewActionArray);
        for (ViewAction viewAction : viewActionArray) {
            SingleExecutionViewAction singleExecutionViewAction = new SingleExecutionViewAction(viewAction, this.viewMatcher);
            this.desugaredPerform(singleExecutionViewAction);
        }
        return this;
    }

    private static Map<String, IBinder> getIBindersFromBindables(List<Bindable> list) {
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        for (Bindable bindable : list) {
            hashMap.put(Preconditions.checkNotNull(bindable.getId(), "Bindable id cannot be null!"), Preconditions.checkNotNull(bindable.getIBinder(), "Bindable binder cannot be null!"));
        }
        return ImmutableMap.copyOf(hashMap);
    }

    private static List<Bindable> getBindables(Object ... objectArray) {
        ArrayList<Bindable> arrayList = Lists.newArrayListWithCapacity(objectArray.length);
        for (Object object : objectArray) {
            if (!(object instanceof Bindable)) continue;
            arrayList.add((Bindable)object);
        }
        return arrayList;
    }

    private static Map<String, IBinder> getIBindersFromViewActions(ViewAction ... viewActionArray) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewActionArray));
    }

    private static Map<String, IBinder> getIBindersFromViewAssertions(ViewAssertion ... viewAssertionArray) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewAssertionArray));
    }

    private void desugaredPerform(final SingleExecutionViewAction singleExecutionViewAction) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                ViewInteraction.this.doPerform(singleExecutionViewAction);
                return null;
            }
        };
        ViewAction viewAction = singleExecutionViewAction.getInnerViewAction();
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            arrayList.add(this.remoteExecutor.submit(this.remoteInteraction.createRemotePerformCallable(this.rootMatcherRef.get(), this.viewMatcher, ViewInteraction.getIBindersFromViewActions(singleExecutionViewAction, viewAction), viewAction)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
    }

    public ViewInteraction withFailureHandler(FailureHandler failureHandler) {
        this.failureHandler = Preconditions.checkNotNull(failureHandler);
        return this;
    }

    public ViewInteraction inRoot(Matcher<Root> matcher) {
        this.hasRootMatcher = true;
        this.rootMatcherRef.set(Preconditions.checkNotNull(matcher));
        return this;
    }

    public ViewInteraction noActivity() {
        if (!this.hasRootMatcher) {
            this.rootMatcherRef.set((Matcher<Root>)Matchers.anyOf(RootMatchers.DEFAULT, (Matcher)Matchers.allOf(RootMatchers.hasWindowLayoutParams(), RootMatchers.isSystemAlertWindow())));
        }
        this.needsActivity.set(false);
        return this;
    }

    private void doPerform(SingleExecutionViewAction singleExecutionViewAction) {
        Preconditions.checkNotNull(singleExecutionViewAction);
        Matcher<View> matcher = Preconditions.checkNotNull(singleExecutionViewAction.getConstraints());
        this.uiController.loopMainThreadUntilIdle();
        View view = this.viewFinder.getView();
        Log.i((String)TAG, (String)String.format(Locale.ROOT, "Performing '%s' action on view %s", singleExecutionViewAction.getDescription(), this.viewMatcher));
        if (!matcher.matches((Object)view)) {
            StringDescription stringDescription = new StringDescription((Appendable)new StringBuilder("Action will not be performed because the target view does not match one or more of the following constraints:\n"));
            matcher.describeTo((Description)stringDescription);
            stringDescription.appendText("\nTarget view: ").appendValue((Object)HumanReadables.describe(view));
            if (singleExecutionViewAction.getInnerViewAction() instanceof ScrollToAction && ViewMatchers.isDescendantOfA(ViewMatchers.isAssignableFrom(AdapterView.class)).matches((Object)view)) {
                stringDescription.appendText("\nFurther Info: ScrollToAction on a view inside an AdapterView will not work. Use Espresso.onData to load the view.");
            }
            throw new PerformException.Builder().withActionDescription(singleExecutionViewAction.getDescription()).withViewDescription(this.viewMatcher.toString()).withCause(new RuntimeException(stringDescription.toString())).build();
        }
        singleExecutionViewAction.perform(this.uiController, view);
    }

    public ViewInteraction check(final ViewAssertion viewAssertion) {
        Preconditions.checkNotNull(viewAssertion);
        final SingleExecutionViewAssertion singleExecutionViewAssertion = new SingleExecutionViewAssertion(viewAssertion);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                ViewInteraction.this.uiController.loopMainThreadUntilIdle();
                View view = null;
                NoMatchingViewException noMatchingViewException = null;
                try {
                    view = ViewInteraction.this.viewFinder.getView();
                }
                catch (NoMatchingViewException noMatchingViewException2) {
                    noMatchingViewException = noMatchingViewException2;
                }
                Log.i((String)TAG, (String)String.format(Locale.ROOT, "Checking '%s' assertion on view %s", viewAssertion, ViewInteraction.this.viewMatcher));
                singleExecutionViewAssertion.check(view, noMatchingViewException);
                return null;
            }
        };
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            arrayList.add(this.remoteExecutor.submit(this.remoteInteraction.createRemoteCheckCallable(this.rootMatcherRef.get(), this.viewMatcher, ViewInteraction.getIBindersFromViewAssertions(singleExecutionViewAssertion, viewAssertion), viewAssertion)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
        return this;
    }

    private ListenableFuture<Void> postAsynchronouslyOnUiThread(Callable<Void> callable) {
        ListenableFutureTask<Void> listenableFutureTask = ListenableFutureTask.create(callable);
        this.mainThreadExecutor.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    private void waitForAndHandleInteractionResults(List<ListenableFuture<Void>> list) {
        try {
            this.controlledLooper.drainMainThreadUntilIdle();
            InteractionResultsHandler.gatherAnyResult(list);
        }
        catch (RuntimeException runtimeException) {
            this.failureHandler.handle(runtimeException, this.viewMatcher);
        }
        catch (Error error) {
            this.failureHandler.handle(error, this.viewMatcher);
        }
        finally {
            this.uiController.interruptEspressoTasks();
        }
    }

    private static final class SingleExecutionViewAssertion
    implements ViewAssertion,
    Bindable {
        final ViewAssertion viewAssertion;
        private IInteractionExecutionStatus assertionExecutionStatus = new IInteractionExecutionStatus.Stub(this){
            AtomicBoolean run = new AtomicBoolean(true);

            @Override
            public boolean canExecute() throws RemoteException {
                return this.run.getAndSet(false);
            }
        };

        private SingleExecutionViewAssertion(ViewAssertion viewAssertion) {
            this.viewAssertion = viewAssertion;
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            try {
                if (this.assertionExecutionStatus.canExecute()) {
                    this.viewAssertion.check(view, noMatchingViewException);
                } else {
                    String string = String.valueOf(this.viewAssertion);
                    LogUtil.logDebugWithProcess((String)TAG, (String)new StringBuilder(66 + String.valueOf(string).length()).append("Attempted to execute a Single Execution Assertion more then once: ").append(string).toString(), (Object[])new Object[0]);
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
            }
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.assertionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder iBinder) {
            this.assertionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(iBinder);
        }
    }

    private static final class SingleExecutionViewAction
    implements ViewAction,
    Bindable {
        final ViewAction viewAction;
        final Matcher<View> viewMatcher;
        private IInteractionExecutionStatus actionExecutionStatus = new IInteractionExecutionStatus.Stub(this){
            AtomicBoolean run = new AtomicBoolean(true);

            @Override
            public boolean canExecute() throws RemoteException {
                return this.run.getAndSet(false);
            }
        };

        private SingleExecutionViewAction(ViewAction viewAction, Matcher<View> matcher) {
            this.viewAction = viewAction;
            this.viewMatcher = matcher;
        }

        @Override
        public Matcher<View> getConstraints() {
            return this.viewAction.getConstraints();
        }

        @Override
        public String getDescription() {
            return this.viewAction.getDescription();
        }

        @Override
        public void perform(UiController uiController, View view) {
            try {
                if (this.actionExecutionStatus.canExecute()) {
                    this.viewAction.perform(uiController, view);
                } else {
                    String string = String.valueOf(this.viewAction);
                    LogUtil.logDebugWithProcess((String)TAG, (String)new StringBuilder(63 + String.valueOf(string).length()).append("Attempted to execute a Single Execution Action more then once: ").append(string).toString(), (Object[])new Object[0]);
                }
            }
            catch (RemoteException remoteException) {
                throw new PerformException.Builder().withActionDescription(this.viewAction.getDescription()).withViewDescription(this.viewMatcher.toString()).withCause(new RuntimeException("Unable to query interaction execution status", remoteException.getCause())).build();
            }
        }

        ViewAction getInnerViewAction() {
            return this.viewAction;
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.actionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder iBinder) {
            this.actionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(iBinder);
        }
    }
}

