/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.util.Log;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.IdlingResourceTimeoutException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicy {
    private static final String TAG = "IdlingPolicy";
    private final long idleTimeout;
    private final TimeUnit unit;
    private final ResponseAction errorHandler;

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.unit;
    }

    public void handleTimeout(List<String> list, String string) {
        switch (this.errorHandler) {
            case THROW_APP_NOT_IDLE: {
                throw AppNotIdleException.create(list, string);
            }
            case THROW_IDLE_TIMEOUT: {
                throw new IdlingResourceTimeoutException(list);
            }
            case LOG_ERROR: {
                String string2 = String.valueOf(list);
                Log.w((String)TAG, (String)new StringBuilder(30 + String.valueOf(string2).length()).append("These resources are not idle: ").append(string2).toString());
                break;
            }
            default: {
                String string3 = String.valueOf(list);
                throw new IllegalStateException(new StringBuilder(24 + String.valueOf(string3).length()).append("should never reach here.").append(string3).toString());
            }
        }
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    private IdlingPolicy(Builder builder) {
        Preconditions.checkArgument(builder.idleTimeout > 0L);
        this.idleTimeout = builder.idleTimeout;
        this.unit = Preconditions.checkNotNull(builder.unit);
        this.errorHandler = Preconditions.checkNotNull(builder.errorHandler);
    }

    static class Builder {
        private long idleTimeout = -1L;
        private TimeUnit unit = null;
        private ResponseAction errorHandler = null;

        public Builder() {
        }

        private Builder(IdlingPolicy idlingPolicy) {
            this.idleTimeout = idlingPolicy.idleTimeout;
            this.unit = idlingPolicy.unit;
            this.errorHandler = idlingPolicy.errorHandler;
        }

        public IdlingPolicy build() {
            return new IdlingPolicy(this);
        }

        public Builder withIdlingTimeout(long l) {
            this.idleTimeout = l;
            return this;
        }

        public Builder withIdlingTimeoutUnit(TimeUnit timeUnit) {
            this.unit = timeUnit;
            return this;
        }

        public Builder throwAppNotIdleException() {
            this.errorHandler = ResponseAction.THROW_APP_NOT_IDLE;
            return this;
        }

        public Builder throwIdlingResourceTimeoutException() {
            this.errorHandler = ResponseAction.THROW_IDLE_TIMEOUT;
            return this;
        }

        public Builder logWarning() {
            this.errorHandler = ResponseAction.LOG_ERROR;
            return this;
        }
    }

    private static enum ResponseAction {
        THROW_APP_NOT_IDLE,
        THROW_IDLE_TIMEOUT,
        LOG_ERROR;

    }
}

