/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.Looper;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.List;
import java.util.Locale;

public final class AppNotIdleException
extends RuntimeException
implements EspressoException {
    private AppNotIdleException(String string) {
        super(string);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AppNotIdleException.txt");
    }

    @Deprecated
    public static AppNotIdleException create(List<String> list, int n, int n2) {
        Preconditions.checkState(Looper.myLooper() == Looper.getMainLooper());
        String string = String.format(Locale.ROOT, "App not idle within timeout of %s seconds evenafter trying for %s iterations. The following Idle Conditions failed %s", n2, n, Joiner.on(",").join(list));
        return new AppNotIdleException(string);
    }

    public static AppNotIdleException create(List<String> list, String string) {
        String string2 = String.format(Locale.ROOT, "%s The following Idle Conditions failed %s.", string, Joiner.on(",").join(list));
        return new AppNotIdleException(string2);
    }
}

