/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class TreeIterables {
    private static final TreeViewer<View> VIEW_TREE_VIEWER = new ViewTreeViewer();

    private TreeIterables() {
    }

    public static Iterable<ViewAndDistance> depthFirstViewTraversalWithDistance(View view) {
        final DistanceRecordingTreeViewer<View> distanceRecordingTreeViewer = new DistanceRecordingTreeViewer<View>(view, VIEW_TREE_VIEWER);
        return Iterables.transform(TreeIterables.depthFirstTraversal(view, distanceRecordingTreeViewer), new Function<View, ViewAndDistance>(){

            @Override
            public ViewAndDistance apply(View view) {
                return new ViewAndDistance(view, distanceRecordingTreeViewer.getDistance(view));
            }
        });
    }

    public static Iterable<View> depthFirstViewTraversal(View view) {
        return TreeIterables.depthFirstTraversal(view, VIEW_TREE_VIEWER);
    }

    public static Iterable<View> breadthFirstViewTraversal(View view) {
        return TreeIterables.breadthFirstTraversal(view, VIEW_TREE_VIEWER);
    }

    static <T> Iterable<T> depthFirstTraversal(T t, TreeViewer<T> treeViewer) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(treeViewer);
        return new TreeTraversalIterable(t, TraversalStrategy.DEPTH_FIRST, treeViewer);
    }

    static <T> Iterable<T> breadthFirstTraversal(T t, TreeViewer<T> treeViewer) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(treeViewer);
        return new TreeTraversalIterable(t, TraversalStrategy.BREADTH_FIRST, treeViewer);
    }

    public static class ViewAndDistance {
        private final View view;
        private final int distanceFromRoot;

        private ViewAndDistance(View view, int n) {
            this.view = view;
            this.distanceFromRoot = n;
        }

        public View getView() {
            return this.view;
        }

        public int getDistanceFromRoot() {
            return this.distanceFromRoot;
        }
    }

    static interface TreeViewer<T> {
        public Collection<T> children(T var1);
    }

    static class DistanceRecordingTreeViewer<T>
    implements TreeViewer<T> {
        private final T root;
        private final Map<T, Integer> nodeToDistance = Maps.newHashMap();
        private final TreeViewer<T> delegateViewer;

        DistanceRecordingTreeViewer(T t, TreeViewer<T> treeViewer) {
            this.root = Preconditions.checkNotNull(t);
            this.delegateViewer = Preconditions.checkNotNull(treeViewer);
        }

        int getDistance(T t) {
            return Preconditions.checkNotNull(this.nodeToDistance.get(t), "Never seen %s before", t);
        }

        @Override
        public Collection<T> children(T t) {
            if (t == this.root) {
                this.nodeToDistance.put(t, 0);
            }
            int n = this.getDistance(t);
            int n2 = n + 1;
            Collection<T> collection = this.delegateViewer.children(t);
            for (T t2 : collection) {
                this.nodeToDistance.put(t2, n2);
            }
            return collection;
        }
    }

    static class ViewTreeViewer
    implements TreeViewer<View> {
        ViewTreeViewer() {
        }

        @Override
        public Collection<View> children(View view) {
            Preconditions.checkNotNull(view);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int n = viewGroup.getChildCount();
                ArrayList<View> arrayList = Lists.newArrayList();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(viewGroup.getChildAt(i));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }
    }

    private static enum TraversalStrategy {
        BREADTH_FIRST{

            @Override
            <T> void combineNewChildren(LinkedList<T> linkedList, Collection<T> collection) {
                linkedList.addAll(collection);
            }
        }
        ,
        DEPTH_FIRST{

            @Override
            <T> void combineNewChildren(LinkedList<T> linkedList, Collection<T> collection) {
                linkedList.addAll(0, collection);
            }
        };


        abstract <T> void combineNewChildren(LinkedList<T> var1, Collection<T> var2);

        <T> T next(LinkedList<T> linkedList) {
            return linkedList.removeFirst();
        }
    }

    private static class TreeTraversalIterable<T>
    implements Iterable<T> {
        private final T root;
        private final TraversalStrategy traversalStrategy;
        private final TreeViewer<T> treeViewer;

        private TreeTraversalIterable(T t, TraversalStrategy traversalStrategy, TreeViewer<T> treeViewer) {
            this.root = Preconditions.checkNotNull(t);
            this.traversalStrategy = Preconditions.checkNotNull(traversalStrategy);
            this.treeViewer = Preconditions.checkNotNull(treeViewer);
        }

        @Override
        public Iterator<T> iterator() {
            final LinkedList<T> linkedList = Lists.newLinkedList();
            linkedList.add(this.root);
            return new AbstractIterator<T>(){

                @Override
                public T computeNext() {
                    if (linkedList.isEmpty()) {
                        return this.endOfData();
                    }
                    Object t = Preconditions.checkNotNull(TreeTraversalIterable.this.traversalStrategy.next(linkedList), "Null items not allowed!");
                    TreeTraversalIterable.this.traversalStrategy.combineNewChildren(linkedList, TreeTraversalIterable.this.treeViewer.children(t));
                    return t;
                }
            };
        }
    }
}

