/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.preference.Preference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class PreferenceMatchers {
    private PreferenceMatchers() {
    }

    public static Matcher<Preference> withSummary(final int n) {
        return new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with summary string from resource id: ");
                description.appendValue((Object)n);
                if (null != this.resourceName) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (null != this.expectedText) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                }
            }

            public boolean matchesSafely(Preference preference) {
                if (null == this.expectedText) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(n);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                if (null != this.expectedText) {
                    return this.expectedText.equals(preference.getSummary().toString());
                }
                return false;
            }
        };
    }

    public static Matcher<Preference> withSummaryText(String string) {
        return PreferenceMatchers.withSummaryText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withSummaryText(final Matcher<String> matcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with summary matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference preference) {
                String string = preference.getSummary().toString();
                return matcher.matches((Object)string);
            }
        };
    }

    public static Matcher<Preference> withTitle(final int n) {
        return new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with title string from resource id: ");
                description.appendValue((Object)n);
                if (null != this.resourceName) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (null != this.expectedText) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                }
            }

            public boolean matchesSafely(Preference preference) {
                if (null == this.expectedText) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(n);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                if (null != this.expectedText && preference.getTitle() != null) {
                    return this.expectedText.equals(preference.getTitle().toString());
                }
                return false;
            }
        };
    }

    public static Matcher<Preference> withTitleText(String string) {
        return PreferenceMatchers.withTitleText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withTitleText(final Matcher<String> matcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with title matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference preference) {
                if (preference.getTitle() == null) {
                    return false;
                }
                String string = preference.getTitle().toString();
                return matcher.matches((Object)string);
            }
        };
    }

    public static Matcher<Preference> isEnabled() {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" is an enabled preference");
            }

            public boolean matchesSafely(Preference preference) {
                return preference.isEnabled();
            }
        };
    }

    public static Matcher<Preference> withKey(String string) {
        return PreferenceMatchers.withKey((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withKey(final Matcher<String> matcher) {
        return new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" preference with key matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference preference) {
                return matcher.matches((Object)preference.getKey());
            }
        };
    }
}

