/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;

final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;
    private transient int cachedHashCode;

    SingletonImmutableSet(E e) {
        this.element = Preconditions.checkNotNull(e);
    }

    SingletonImmutableSet(E e, int n) {
        this.element = e;
        this.cachedHashCode = n;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object object) {
        return this.element.equals(object);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    ImmutableList<E> createAsList() {
        return ImmutableList.of(this.element);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        objectArray[n] = this.element;
        return n + 1;
    }

    @Override
    public final int hashCode() {
        int n = this.cachedHashCode;
        if (n == 0) {
            this.cachedHashCode = n = this.element.hashCode();
        }
        return n;
    }

    @Override
    boolean isHashCodeFast() {
        return this.cachedHashCode != 0;
    }

    @Override
    public String toString() {
        String string = this.element.toString();
        return new StringBuilder(2 + String.valueOf(string).length()).append('[').append(string).append(']').toString();
    }
}

