/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class WindowManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = WindowManagerEventInjectionStrategy.class.getSimpleName();
    private boolean initComplete;
    private Object wmInstance;
    private Method injectInputKeyEventMethod;
    private Method injectInputMotionEventMethod;

    WindowManagerEventInjectionStrategy() {
        Preconditions.checkState(Build.VERSION.SDK_INT >= 7 && Build.VERSION.SDK_INT <= 15, "Unsupported API level.");
    }

    void initialize() {
        if (this.initComplete) {
            return;
        }
        try {
            Log.d((String)TAG, (String)"Trying to create injection strategy.");
            Class<?> clazz = Class.forName("android.os.ServiceManager");
            Method method = clazz.getDeclaredMethod("getService", String.class);
            method.setAccessible(true);
            Object object = method.invoke(clazz, "window");
            Class<?> clazz2 = Class.forName("android.view.IWindowManager$Stub");
            Method method2 = clazz2.getDeclaredMethod("asInterface", IBinder.class);
            method2.setAccessible(true);
            this.wmInstance = method2.invoke(clazz2, object);
            this.injectInputMotionEventMethod = this.wmInstance.getClass().getDeclaredMethod("injectPointerEvent", MotionEvent.class, Boolean.TYPE);
            this.injectInputMotionEventMethod.setAccessible(true);
            this.injectInputKeyEventMethod = this.wmInstance.getClass().getDeclaredMethod("injectKeyEvent", KeyEvent.class, Boolean.TYPE);
            this.injectInputKeyEventMethod.setAccessible(true);
            this.initComplete = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
    }

    @Override
    public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        try {
            return (Boolean)this.injectInputKeyEventMethod.invoke(this.wmInstance, keyEvent, true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SecurityException) {
                throw new InjectEventSecurityException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new InjectEventSecurityException(securityException);
        }
    }

    @Override
    public boolean injectMotionEvent(MotionEvent motionEvent, boolean bl) throws InjectEventSecurityException {
        try {
            return (Boolean)this.injectInputMotionEventMethod.invoke(this.wmInstance, motionEvent, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SecurityException) {
                throw new InjectEventSecurityException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new InjectEventSecurityException(securityException);
        }
    }
}

