/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;

final class ThreadPoolExecutorExtractor {
    private static final String ASYNC_TASK_CLASS_NAME = "android.os.AsyncTask";
    private static final String MODERN_ASYNC_TASK_CLASS_NAME = "androidx.loader.content.ModernAsyncTask";
    private static final String MODERN_ASYNC_TASK_FIELD_NAME = "THREAD_POOL_EXECUTOR";
    private static final String LEGACY_ASYNC_TASK_FIELD_NAME = "sExecutor";
    private final Handler mainHandler;
    private static final Callable<Optional<ThreadPoolExecutor>> MODERN_ASYNC_TASK_EXTRACTOR = new Callable<Optional<ThreadPoolExecutor>>(){

        @Override
        public Optional<ThreadPoolExecutor> call() throws Exception {
            try {
                Class<?> clazz = Class.forName(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_CLASS_NAME);
                Field field = clazz.getField(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_FIELD_NAME);
                return Optional.of((ThreadPoolExecutor)field.get(null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Optional.absent();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return Optional.absent();
            }
        }
    };
    private static final Callable<Class<?>> LOAD_ASYNC_TASK_CLASS = new Callable<Class<?>>(){

        @Override
        public Class<?> call() throws Exception {
            return Class.forName(ThreadPoolExecutorExtractor.ASYNC_TASK_CLASS_NAME);
        }
    };
    private static final Callable<Optional<ThreadPoolExecutor>> LEGACY_ASYNC_TASK_EXECUTOR = new Callable<Optional<ThreadPoolExecutor>>(){

        @Override
        public Optional<ThreadPoolExecutor> call() throws Exception {
            try {
                Field field = ((Class)LOAD_ASYNC_TASK_CLASS.call()).getDeclaredField(ThreadPoolExecutorExtractor.LEGACY_ASYNC_TASK_FIELD_NAME);
                field.setAccessible(true);
                return Optional.of((ThreadPoolExecutor)field.get(null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Optional.absent();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return Optional.absent();
            }
        }
    };
    private static final Callable<Optional<ThreadPoolExecutor>> POST_HONEYCOMB_ASYNC_TASK_EXECUTOR = new Callable<Optional<ThreadPoolExecutor>>(){

        @Override
        public Optional<ThreadPoolExecutor> call() throws Exception {
            try {
                Field field = ((Class)LOAD_ASYNC_TASK_CLASS.call()).getField(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_FIELD_NAME);
                return Optional.of((ThreadPoolExecutor)field.get(null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Optional.absent();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return Optional.absent();
            }
        }
    };

    ThreadPoolExecutorExtractor(Looper looper) {
        this.mainHandler = new Handler(looper);
    }

    public ThreadPoolExecutor getAsyncTaskThreadPool() {
        FutureTask<Optional<ThreadPoolExecutor>> futureTask = null;
        futureTask = Build.VERSION.SDK_INT < 11 ? new FutureTask<Optional<ThreadPoolExecutor>>(LEGACY_ASYNC_TASK_EXECUTOR) : new FutureTask<Optional<ThreadPoolExecutor>>(POST_HONEYCOMB_ASYNC_TASK_EXECUTOR);
        try {
            return this.runOnMainThread(futureTask).get().get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to get the async task executor!", interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException.getCause());
        }
    }

    public Optional<ThreadPoolExecutor> getCompatAsyncTaskThreadPool() {
        try {
            return this.runOnMainThread(new FutureTask<Optional<ThreadPoolExecutor>>(MODERN_ASYNC_TASK_EXTRACTOR)).get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to get the compat async executor!", interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> FutureTask<T> runOnMainThread(final FutureTask<T> futureTask) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            this.mainHandler.post(new Runnable(this){

                @Override
                public void run() {
                    try {
                        futureTask.run();
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
            try {
                countDownLatch.await();
                return futureTask;
            }
            catch (InterruptedException interruptedException) {
                if (futureTask.isDone()) return futureTask;
                throw new RuntimeException("Interrupted while waiting for task to complete.");
            }
        } else {
            futureTask.run();
        }
        return futureTask;
    }
}

