/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.LooperIdlingResourceInterrogationHandler;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class IdlingResourceRegistry {
    private static final String TAG = IdlingResourceRegistry.class.getSimpleName();
    private static final int DYNAMIC_RESOURCE_HAS_IDLED = 1;
    private static final int TIMEOUT_OCCURRED = 2;
    private static final int IDLE_WARNING_REACHED = 3;
    private static final int POSSIBLE_RACE_CONDITION_DETECTED = 4;
    private static final Object TIMEOUT_MESSAGE_TAG = new Object();
    private static final IdleNotificationCallback NO_OP_CALLBACK = new IdleNotificationCallback(){

        @Override
        public void allResourcesIdle() {
        }

        @Override
        public void resourcesStillBusyWarning(List<String> list) {
        }

        @Override
        public void resourcesHaveTimedOut(List<String> list) {
        }
    };
    private final List<IdlingState> idlingStates = new ArrayList<IdlingState>();
    private final Looper looper;
    private final Handler handler;
    private final Dispatcher dispatcher;
    private IdleNotificationCallback idleNotificationCallback = NO_OP_CALLBACK;

    public IdlingResourceRegistry(Looper looper) {
        this.looper = looper;
        this.dispatcher = new Dispatcher();
        this.handler = new Handler(looper, (Handler.Callback)this.dispatcher);
    }

    public void sync(final Iterable<IdlingResource> iterable, final Iterable<Looper> iterable2) {
        if (Looper.myLooper() != this.looper) {
            this.runSynchronouslyOnMainThread(new Callable<Void>(){

                @Override
                public Void call() {
                    IdlingResourceRegistry.this.sync(iterable, iterable2);
                    return null;
                }
            });
        } else {
            HashMap<String, IdlingResource> hashMap = new HashMap<String, IdlingResource>();
            for (IdlingResource object : iterable) {
                if (hashMap.containsKey(object.getName())) {
                    this.logDuplicateRegistrationError(object, (IdlingResource)hashMap.get(object.getName()));
                    continue;
                }
                hashMap.put(object.getName(), object);
            }
            for (Looper looper : iterable2) {
                LooperIdlingResourceInterrogationHandler looperIdlingResourceInterrogationHandler = LooperIdlingResourceInterrogationHandler.forLooper(looper);
                if (hashMap.containsKey(looperIdlingResourceInterrogationHandler.getName())) {
                    this.logDuplicateRegistrationError(looperIdlingResourceInterrogationHandler, (IdlingResource)hashMap.get(looperIdlingResourceInterrogationHandler.getName()));
                    continue;
                }
                hashMap.put(looperIdlingResourceInterrogationHandler.getName(), looperIdlingResourceInterrogationHandler);
            }
            ArrayList arrayList = new ArrayList();
            for (IdlingState idlingState : this.idlingStates) {
                IdlingResource idlingResource = (IdlingResource)hashMap.remove(idlingState.resource.getName());
                if (null == idlingResource) {
                    arrayList.add(idlingState.resource);
                    continue;
                }
                if (idlingState.resource == idlingResource) continue;
                arrayList.add(idlingState.resource);
                hashMap.put(idlingResource.getName(), idlingResource);
            }
            this.unregisterResources(arrayList);
            this.registerResources(Lists.newArrayList(hashMap.values()));
        }
    }

    public boolean registerResources(final List<? extends IdlingResource> list) {
        if (Looper.myLooper() != this.looper) {
            return this.runSynchronouslyOnMainThread(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return IdlingResourceRegistry.this.registerResources(list);
                }
            });
        }
        boolean bl = true;
        for (IdlingResource idlingResource : list) {
            Preconditions.checkNotNull(idlingResource.getName(), "IdlingResource.getName() should not be null");
            boolean bl2 = false;
            for (IdlingState idlingState : this.idlingStates) {
                if (!idlingResource.getName().equals(idlingState.resource.getName())) continue;
                this.logDuplicateRegistrationError(idlingResource, idlingState.resource);
                bl2 = true;
                break;
            }
            if (!bl2) {
                IdlingState idlingState = new IdlingState(idlingResource, this.handler);
                this.idlingStates.add(idlingState);
                idlingState.registerSelf();
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public boolean unregisterResources(final List<? extends IdlingResource> list) {
        if (Looper.myLooper() != this.looper) {
            return this.runSynchronouslyOnMainThread(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return IdlingResourceRegistry.this.unregisterResources(list);
                }
            });
        }
        boolean bl = true;
        for (IdlingResource idlingResource : list) {
            boolean bl2 = false;
            for (int i = 0; i < this.idlingStates.size(); ++i) {
                if (!this.idlingStates.get((int)i).resource.getName().equals(idlingResource.getName())) continue;
                this.idlingStates.remove(i);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
            Log.e((String)TAG, (String)String.format("Attempted to unregister resource that is not registered: '%s'. Resource list: %s", idlingResource.getName(), this.getResources()));
        }
        return bl;
    }

    public void registerLooper(Looper looper, boolean bl) {
        Preconditions.checkNotNull(looper);
        Preconditions.checkArgument(Looper.getMainLooper() != looper, "Not intended for use with main looper!");
        this.registerResources(Lists.newArrayList(LooperIdlingResourceInterrogationHandler.forLooper(looper)));
    }

    public List<IdlingResource> getResources() {
        if (Looper.myLooper() != this.looper) {
            return this.runSynchronouslyOnMainThread(new Callable<List<IdlingResource>>(){

                @Override
                public List<IdlingResource> call() {
                    return IdlingResourceRegistry.this.getResources();
                }
            });
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IdlingState idlingState : this.idlingStates) {
            builder.add(idlingState.resource);
        }
        return builder.build();
    }

    boolean allResourcesAreIdle() {
        Preconditions.checkState(Looper.myLooper() == this.looper);
        for (IdlingState idlingState : this.idlingStates) {
            if (idlingState.idle) {
                idlingState.idle = idlingState.resource.isIdleNow();
            }
            if (idlingState.idle) continue;
            return false;
        }
        return true;
    }

    void notifyWhenAllResourcesAreIdle(IdleNotificationCallback idleNotificationCallback) {
        Preconditions.checkNotNull(idleNotificationCallback);
        Preconditions.checkState(Looper.myLooper() == this.looper);
        Preconditions.checkState(this.idleNotificationCallback == NO_OP_CALLBACK, "Callback has already been registered.");
        if (this.allResourcesAreIdle()) {
            idleNotificationCallback.allResourcesIdle();
        } else {
            this.idleNotificationCallback = idleNotificationCallback;
            this.scheduleTimeoutMessages();
        }
    }

    IdleNotifier<IdleNotificationCallback> asIdleNotifier() {
        return new IdleNotifier<IdleNotificationCallback>(){

            @Override
            public boolean isIdleNow() {
                return IdlingResourceRegistry.this.allResourcesAreIdle();
            }

            @Override
            public void cancelCallback() {
                IdlingResourceRegistry.this.cancelIdleMonitor();
            }

            @Override
            public void registerNotificationCallback(IdleNotificationCallback idleNotificationCallback) {
                IdlingResourceRegistry.this.notifyWhenAllResourcesAreIdle(idleNotificationCallback);
            }
        };
    }

    void cancelIdleMonitor() {
        this.dispatcher.deregister();
    }

    private <T> T runSynchronouslyOnMainThread(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        this.handler.post(futureTask);
        try {
            return futureTask.get();
        }
        catch (CancellationException cancellationException) {
            throw new RuntimeException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private void scheduleTimeoutMessages() {
        IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
        Message message = this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG);
        this.handler.sendMessageDelayed(message, idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
        Message message2 = this.handler.obtainMessage(2, TIMEOUT_MESSAGE_TAG);
        IdlingPolicy idlingPolicy2 = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
        this.handler.sendMessageDelayed(message2, idlingPolicy2.getIdleTimeoutUnit().toMillis(idlingPolicy2.getIdleTimeout()));
    }

    private List<String> getBusyResources() {
        ArrayList<String> arrayList = Lists.newArrayList();
        ArrayList<IdlingState> arrayList2 = Lists.newArrayList();
        for (IdlingState idlingState : this.idlingStates) {
            if (idlingState.idle) continue;
            if (idlingState.resource.isIdleNow()) {
                arrayList2.add(idlingState);
                continue;
            }
            arrayList.add(idlingState.resource.getName());
        }
        if (!arrayList2.isEmpty()) {
            Message message = this.handler.obtainMessage(4, TIMEOUT_MESSAGE_TAG);
            message.obj = arrayList2;
            this.handler.sendMessage(message);
            return null;
        }
        return arrayList;
    }

    private void logDuplicateRegistrationError(IdlingResource idlingResource, IdlingResource idlingResource2) {
        Log.e((String)TAG, (String)String.format("Attempted to register resource with same names: %s. R1: %s R2: %s.\nDuplicate resource registration will be ignored.", idlingResource.getName(), idlingResource, idlingResource2));
    }

    private class Dispatcher
    implements Handler.Callback {
        private Dispatcher() {
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    this.handleResourceIdled(message);
                    break;
                }
                case 3: {
                    this.handleTimeoutWarning();
                    break;
                }
                case 2: {
                    this.handleTimeout();
                    break;
                }
                case 4: {
                    this.handleRaceCondition(message);
                    break;
                }
                default: {
                    String string = String.valueOf(message);
                    Log.w((String)TAG, (String)new StringBuilder(22 + String.valueOf(string).length()).append("Unknown message type: ").append(string).toString());
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResourceIdled(Message message) {
            IdlingState idlingState = (IdlingState)message.obj;
            idlingState.idle = true;
            boolean bl = true;
            boolean bl2 = true;
            for (IdlingState idlingState2 : IdlingResourceRegistry.this.idlingStates) {
                boolean bl3 = bl2 = bl2 && idlingState2.idle;
                if (!bl && !bl2) break;
                if (!bl || idlingState2 != idlingState) continue;
                bl = false;
            }
            if (bl) {
                String string = String.valueOf(idlingState.resource);
                Log.i((String)TAG, (String)new StringBuilder(45 + String.valueOf(string).length()).append("Ignoring message from unregistered resource: ").append(string).toString());
                return;
            }
            if (bl2) {
                try {
                    IdlingResourceRegistry.this.idleNotificationCallback.allResourcesIdle();
                }
                finally {
                    this.deregister();
                }
            }
        }

        private void handleTimeoutWarning() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG));
            } else {
                IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
                IdlingResourceRegistry.this.idleNotificationCallback.resourcesStillBusyWarning(list);
                IdlingResourceRegistry.this.handler.sendMessageDelayed(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG), idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
            }
        }

        private void handleTimeout() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(2, TIMEOUT_MESSAGE_TAG));
            } else {
                try {
                    IdlingResourceRegistry.this.idleNotificationCallback.resourcesHaveTimedOut(list);
                }
                finally {
                    this.deregister();
                }
            }
        }

        private void handleRaceCondition(Message message) {
            for (IdlingState idlingState : (List)message.obj) {
                if (idlingState.idle) continue;
                throw new IllegalStateException(String.format("Resource %s isIdleNow() is returning true, but a message indicating that the resource has transitioned from busy to idle was never sent.", idlingState.resource.getName()));
            }
        }

        private void deregister() {
            IdlingResourceRegistry.this.handler.removeCallbacksAndMessages(TIMEOUT_MESSAGE_TAG);
            IdlingResourceRegistry.this.idleNotificationCallback = NO_OP_CALLBACK;
        }
    }

    private static class IdlingState
    implements IdlingResource.ResourceCallback {
        final IdlingResource resource;
        final Handler handler;
        boolean idle;

        private IdlingState(IdlingResource idlingResource, Handler handler) {
            this.resource = idlingResource;
            this.handler = handler;
        }

        private void registerSelf() {
            this.resource.registerIdleTransitionCallback((IdlingResource.ResourceCallback)this);
            this.idle = this.resource.isIdleNow();
        }

        public void onTransitionToIdle() {
            Message message = this.handler.obtainMessage(1);
            message.obj = this;
            this.handler.sendMessage(message);
        }
    }

    static interface IdleNotificationCallback {
        public void allResourcesIdle();

        public void resourcesStillBusyWarning(List<String> var1);

        public void resourcesHaveTimedOut(List<String> var1);
    }
}

