/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class CloseKeyboardAction
implements ViewAction {
    private static final int NUM_RETRIES = 3;
    private static final String TAG = CloseKeyboardAction.class.getSimpleName();

    @RemoteMsgConstructor
    public CloseKeyboardAction() {
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.any(View.class);
    }

    @Override
    public void perform(UiController uiController, View view) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.tryToCloseKeyboard(view, uiController);
                return;
            }
            catch (TimeoutException timeoutException) {
                Log.w((String)TAG, (String)"Caught timeout exception. Retrying.");
                if (i != 2) continue;
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(timeoutException).build();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToCloseKeyboard(View view, UiController uiController) throws TimeoutException {
        CloseKeyboardIdlingResult closeKeyboardIdlingResult;
        block5: {
            InputMethodManager inputMethodManager = (InputMethodManager)CloseKeyboardAction.getRootActivity(uiController).getSystemService("input_method");
            closeKeyboardIdlingResult = new CloseKeyboardIdlingResult(new Handler(Looper.getMainLooper()));
            IdlingRegistry.getInstance().register(new IdlingResource[]{closeKeyboardIdlingResult});
            try {
                if (inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0, (ResultReceiver)closeKeyboardIdlingResult)) break block5;
                Log.w((String)TAG, (String)"Attempting to close soft keyboard, while it is not shown.");
            }
            catch (Throwable throwable) {
                IdlingRegistry.getInstance().unregister(new IdlingResource[]{closeKeyboardIdlingResult});
                throw throwable;
            }
            IdlingRegistry.getInstance().unregister(new IdlingResource[]{closeKeyboardIdlingResult});
            return;
        }
        closeKeyboardIdlingResult.scheduleTimeout(2000L);
        uiController.loopMainThreadUntilIdle();
        if (closeKeyboardIdlingResult.timedOut) {
            throw new TimeoutException("Wait on operation result timed out.");
        }
        IdlingRegistry.getInstance().unregister(new IdlingResource[]{closeKeyboardIdlingResult});
        if (closeKeyboardIdlingResult.result != 1 && closeKeyboardIdlingResult.result != 3) {
            int n = closeKeyboardIdlingResult.result;
            String string = new StringBuilder(105).append("Attempt to close the soft keyboard did not result in soft keyboard to be hidden. resultCode = ").append(n).toString();
            Log.e((String)TAG, (String)string);
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(string)).build();
        }
    }

    private static Activity getRootActivity(UiController uiController) {
        Collection collection = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (collection.isEmpty()) {
            uiController.loopMainThreadUntilIdle();
            collection = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        }
        Preconditions.checkState(collection.size() == 1, "More than one activity is in RESUMED stage. There may have been an error during the activity creation/startup process, please check your logs.");
        return (Activity)Iterables.getOnlyElement(collection);
    }

    @Override
    public String getDescription() {
        return "close keyboard";
    }

    private static class CloseKeyboardIdlingResult
    extends ResultReceiver
    implements IdlingResource {
        private IdlingResource.ResourceCallback resourceCallback;
        private boolean receivedResult = false;
        private int result = -1;
        private boolean timedOut = false;
        private boolean idle = false;
        private final Handler handler;

        private CloseKeyboardIdlingResult(Handler handler) {
            super(handler);
            this.handler = handler;
        }

        private void scheduleTimeout(long l) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!CloseKeyboardIdlingResult.this.receivedResult) {
                        CloseKeyboardIdlingResult.this.timedOut = true;
                        if (null != CloseKeyboardIdlingResult.this.resourceCallback) {
                            CloseKeyboardIdlingResult.this.resourceCallback.onTransitionToIdle();
                        }
                    }
                }
            }, l);
        }

        private void notifyEspresso(long l) {
            Preconditions.checkState(this.receivedResult);
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CloseKeyboardIdlingResult.this.idle = true;
                    if (null != CloseKeyboardIdlingResult.this.resourceCallback) {
                        CloseKeyboardIdlingResult.this.resourceCallback.onTransitionToIdle();
                    }
                }
            }, l);
        }

        protected void onReceiveResult(int n, Bundle bundle) {
            this.result = n;
            this.receivedResult = true;
            this.notifyEspresso(300L);
        }

        public String getName() {
            return "CloseKeyboardIdlingResource";
        }

        public boolean isIdleNow() {
            return this.idle || this.timedOut;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
            this.resourceCallback = resourceCallback;
        }
    }
}

