/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.internal.platform.util.TestOutputEmitter;

public final class PerformException
extends RuntimeException
implements EspressoException {
    private static final String MESSAGE_FORMAT = "Error performing '%s' on view '%s'.";
    private final String actionDescription;
    private final String viewDescription;

    private PerformException(Builder builder) {
        super(String.format(MESSAGE_FORMAT, builder.actionDescription, builder.viewDescription), builder.cause);
        this.actionDescription = Preconditions.checkNotNull(builder.actionDescription);
        this.viewDescription = Preconditions.checkNotNull(builder.viewDescription);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-PerformException.txt");
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public String getViewDescription() {
        return this.viewDescription;
    }

    public static class Builder {
        private String actionDescription;
        private String viewDescription;
        private Throwable cause;

        public Builder from(PerformException performException) {
            this.actionDescription = performException.getActionDescription();
            this.viewDescription = performException.getViewDescription();
            this.cause = performException.getCause();
            return this;
        }

        public Builder withActionDescription(String string) {
            this.actionDescription = string;
            return this;
        }

        public Builder withViewDescription(String string) {
            this.viewDescription = string;
            return this;
        }

        public Builder withCause(Throwable throwable) {
            this.cause = throwable;
            return this;
        }

        public PerformException build() {
            return new PerformException(this);
        }
    }
}

