/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.util.TestOutputEmitter;
import org.hamcrest.Matcher;

public final class AmbiguousViewMatcherException
extends RuntimeException
implements EspressoException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private View view1;
    private View view2;
    private View[] others;

    private AmbiguousViewMatcherException(String string) {
        super(string);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AmbiguousViewMatcherException.txt");
    }

    private AmbiguousViewMatcherException(Builder builder) {
        super(AmbiguousViewMatcherException.getErrorMessage(builder));
        this.viewMatcher = builder.viewMatcher;
        this.rootView = builder.rootView;
        this.view1 = builder.view1;
        this.view2 = builder.view2;
        this.others = builder.others;
    }

    private static String getErrorMessage(Builder builder) {
        String string = "";
        if (builder.includeViewHierarchy) {
            ImmutableSet immutableSet = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new View[]{builder.view1, builder.view2})).add(builder.others)).build();
            string = HumanReadables.getViewHierarchyErrorMessage(builder.rootView, Lists.newArrayList(immutableSet), String.format("'%s' matches multiple views in the hierarchy.", builder.viewMatcher), "****MATCHES****");
        } else {
            string = String.format("Multiple Ambiguous Views found for matcher %s", builder.viewMatcher);
        }
        return string;
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private View view1;
        private View view2;
        private View[] others;
        private boolean includeViewHierarchy = true;

        public Builder from(AmbiguousViewMatcherException ambiguousViewMatcherException) {
            this.viewMatcher = ambiguousViewMatcherException.viewMatcher;
            this.rootView = ambiguousViewMatcherException.rootView;
            this.view1 = ambiguousViewMatcherException.view1;
            this.view2 = ambiguousViewMatcherException.view2;
            this.others = ambiguousViewMatcherException.others;
            return this;
        }

        public Builder withViewMatcher(Matcher<? super View> matcher) {
            this.viewMatcher = matcher;
            return this;
        }

        public Builder withRootView(View view) {
            this.rootView = view;
            return this;
        }

        public Builder withView1(View view) {
            this.view1 = view;
            return this;
        }

        public Builder withView2(View view) {
            this.view2 = view;
            return this;
        }

        public Builder withOtherAmbiguousViews(View ... viewArray) {
            this.others = viewArray;
            return this;
        }

        public Builder includeViewHierarchy(boolean bl) {
            this.includeViewHierarchy = bl;
            return this;
        }

        public AmbiguousViewMatcherException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.view1);
            Preconditions.checkNotNull(this.view2);
            Preconditions.checkNotNull(this.others);
            return new AmbiguousViewMatcherException(this);
        }
    }
}

