/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ImmediateFuture<V>
implements ListenableFuture<V> {
    private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

    ImmediateFuture() {
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            String string = String.valueOf(runnable);
            String string2 = String.valueOf(executor);
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.ImmediateFuture", "addListener", new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RuntimeException while executing runnable ").append(string).append(" with executor ").append(string2).toString(), runtimeException);
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public abstract V get() throws ExecutionException;

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException {
        Preconditions.checkNotNull(timeUnit);
        return this.get();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    static final class ImmediateFailedFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateFailedFuture(Throwable throwable) {
            this.setException(throwable);
        }
    }

    static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        static final ImmediateSuccessfulFuture<Object> NULL = new ImmediateSuccessfulFuture<Object>(null);
        private final V value;

        ImmediateSuccessfulFuture(V v) {
            this.value = v;
        }

        @Override
        public V get() {
            return this.value;
        }

        public String toString() {
            String string = super.toString();
            String string2 = String.valueOf(this.value);
            return new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[status=SUCCESS, result=[").append(string2).append("]]").toString();
        }
    }
}

