/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> ofInstance(T t) {
        return new SupplierOfInstance<T>(t);
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;
        private static final long serialVersionUID = 0L;

        SupplierOfInstance(T t) {
            this.instance = t;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object object) {
            if (object instanceof SupplierOfInstance) {
                SupplierOfInstance supplierOfInstance = (SupplierOfInstance)object;
                return Objects.equal(this.instance, supplierOfInstance.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            String string = String.valueOf(this.instance);
            return new StringBuilder(22 + String.valueOf(string).length()).append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }
}

