/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.UiController$$CC;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import java.util.List;

public class UiControllerModule {
    public UiController provideUiController(UiControllerImpl uiControllerImpl) {
        List list = ServiceLoaderWrapper.loadService(androidx.test.platform.ui.UiController.class);
        if (list.isEmpty()) {
            return uiControllerImpl;
        }
        if (list.size() == 1) {
            return new EspressoUiControllerAdapter((androidx.test.platform.ui.UiController)list.get(0));
        }
        throw new IllegalStateException("Found more than one androidx.test.internal.platform.UiController");
    }

    private static class EspressoUiControllerAdapter
    implements InterruptableUiController {
        private final androidx.test.platform.ui.UiController platformUiController;

        private EspressoUiControllerAdapter(androidx.test.platform.ui.UiController uiController) {
            this.platformUiController = uiController;
        }

        @Override
        public boolean injectMotionEvent(MotionEvent motionEvent) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectMotionEvent(motionEvent);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                throw new InjectEventSecurityException(injectEventSecurityException);
            }
        }

        @Override
        public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectKeyEvent(keyEvent);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                throw new InjectEventSecurityException(injectEventSecurityException);
            }
        }

        @Override
        public boolean injectString(String string) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectString(string);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                throw new InjectEventSecurityException(injectEventSecurityException);
            }
        }

        @Override
        public void loopMainThreadUntilIdle() {
            this.platformUiController.loopMainThreadUntilIdle();
        }

        @Override
        public void loopMainThreadForAtLeast(long l) {
            this.platformUiController.loopMainThreadForAtLeast(l);
        }

        @Override
        public void interruptEspressoTasks() {
            Log.w((String)"UiController", (String)"interruptEspressoTasks called, no-op");
        }

        public boolean injectMotionEventSequence(Iterable iterable) throws InjectEventSecurityException {
            return UiController$$CC.injectMotionEventSequence(this, iterable);
        }
    }
}

