/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Looper;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.NoMatchingRootException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.RootViewPickerScope;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.internal.util.LogUtil;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@RootViewPickerScope
public final class RootViewPicker
implements Provider<View> {
    private static final String TAG = RootViewPicker.class.getSimpleName();
    private static final ImmutableList<Integer> CREATED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(150), Integer.valueOf(250));
    private static final ImmutableList<Integer> RESUMED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(500), Integer.valueOf(2000), Integer.valueOf(30000));
    private final UiController uiController;
    private final ActivityLifecycleMonitor activityLifecycleMonitor;
    private final AtomicReference<Boolean> needsActivity;
    private final RootResultFetcher rootResultFetcher;

    RootViewPicker(UiController uiController, RootResultFetcher rootResultFetcher, ActivityLifecycleMonitor activityLifecycleMonitor, AtomicReference<Boolean> atomicReference) {
        this.uiController = uiController;
        this.rootResultFetcher = rootResultFetcher;
        this.activityLifecycleMonitor = activityLifecycleMonitor;
        this.needsActivity = atomicReference;
    }

    public View get() {
        Preconditions.checkState(Looper.getMainLooper().equals(Looper.myLooper()), "must be called on main thread.");
        if (this.needsActivity.get().booleanValue()) {
            this.waitForAtLeastOneActivityToBeResumed();
        }
        return this.pickRootView();
    }

    private Root waitForRootToBeReady(Root root) {
        long l = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        RootReadyBackoff rootReadyBackoff = new RootReadyBackoff();
        while (System.currentTimeMillis() <= l) {
            if (root.isReady()) {
                return root;
            }
            this.uiController.loopMainThreadForAtLeast(((BackOff)rootReadyBackoff).getNextBackoffInMillis());
        }
        throw new RuntimeException(String.format("Waited for the root of the view hierarchy to have window focus and not request layout for 10 seconds. If you specified a non default root matcher, it may be picking a root that never takes focus. Root:\n%s", root));
    }

    private Root pickARoot() {
        long l = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        RootResults rootResults = this.rootResultFetcher.fetch();
        NoActiveRootsBackoff noActiveRootsBackoff = new NoActiveRootsBackoff();
        NoMatchingRootBackoff noMatchingRootBackoff = new NoMatchingRootBackoff();
        while (System.currentTimeMillis() <= l) {
            switch (rootResults.getState()) {
                case ROOTS_PICKED: {
                    return rootResults.getPickedRoot();
                }
                case NO_ROOTS_PRESENT: {
                    this.uiController.loopMainThreadForAtLeast(((BackOff)noActiveRootsBackoff).getNextBackoffInMillis());
                    break;
                }
                case NO_ROOTS_PICKED: {
                    this.uiController.loopMainThreadForAtLeast(((BackOff)noMatchingRootBackoff).getNextBackoffInMillis());
                }
            }
            rootResults = this.rootResultFetcher.fetch();
        }
        if (RootResults.State.ROOTS_PICKED == rootResults.getState()) {
            return rootResults.getPickedRoot();
        }
        throw NoMatchingRootException.create((Matcher<Root>)rootResults.rootSelector, rootResults.allRoots);
    }

    private View pickRootView() {
        return this.waitForRootToBeReady(this.pickARoot()).getDecorView();
    }

    private void waitForAtLeastOneActivityToBeResumed() {
        Collection collection = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        if (collection.isEmpty()) {
            this.uiController.loopMainThreadUntilIdle();
            collection = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        }
        if (collection.isEmpty()) {
            long l;
            ArrayList arrayList = Lists.newArrayList();
            Iterator iterator = CREATED_WAIT_TIMES.iterator();
            while (iterator.hasNext()) {
                l = ((Integer)iterator.next()).intValue();
                for (Stage stage : EnumSet.range(Stage.PRE_ON_CREATE, Stage.RESTARTED)) {
                    arrayList.addAll(this.activityLifecycleMonitor.getActivitiesInStage(stage));
                }
                if (!arrayList.isEmpty()) break;
                Log.w((String)TAG, (String)new StringBuilder(72).append("No activities found - waiting: ").append(l).append("ms for one to appear.").toString());
                this.uiController.loopMainThreadForAtLeast(l);
            }
            if (arrayList.isEmpty()) {
                throw new RuntimeException("No activities found. Did you t to launch the activity by calling getActivity() or startActivitySync or similar?");
            }
            iterator = RESUMED_WAIT_TIMES.iterator();
            while (iterator.hasNext()) {
                l = ((Integer)iterator.next()).intValue();
                Log.w((String)TAG, (String)new StringBuilder(82).append("No activity currently resumed - waiting: ").append(l).append("ms for one to appear.").toString());
                this.uiController.loopMainThreadForAtLeast(l);
                collection = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
                if (collection.isEmpty()) continue;
                return;
            }
            throw new NoActivityResumedException("No activities in stage RESUMED. Did you t to launch the activity. (test.getActivity() or similar)?");
        }
    }

    private static final class RootReadyBackoff
    extends BackOff {
        private static final ImmutableList<Integer> ROOT_READY_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(800), Integer.valueOf(1000));

        public RootReadyBackoff() {
            super(ROOT_READY_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = this.getBackoffForAttempt();
            Log.d((String)TAG, (String)String.format("Root not ready - waiting: %sms for one to appear.", l));
            return l;
        }
    }

    private static final class NoMatchingRootBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_MATCHING_ROOT_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(1000), Integer.valueOf(2000));

        public NoMatchingRootBackoff() {
            super(NO_MATCHING_ROOT_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = this.getBackoffForAttempt();
            Log.d((String)TAG, (String)String.format("No matching root available - waiting: %sms for one to appear.", l));
            return l;
        }
    }

    private static final class NoActiveRootsBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_ACTIVE_ROOTS_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(30), Integer.valueOf(50), Integer.valueOf(80), Integer.valueOf(130), Integer.valueOf(210), Integer.valueOf(340));

        public NoActiveRootsBackoff() {
            super(NO_ACTIVE_ROOTS_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = this.getBackoffForAttempt();
            LogUtil.logDebugWithProcess((String)TAG, (String)"No active roots available - waiting: %sms for one to appear.", (Object[])new Object[]{l});
            return l;
        }
    }

    private static abstract class BackOff {
        private final List<Integer> backoffTimes;
        private final TimeUnit timeUnit;
        private int numberOfAttempts = 0;

        public BackOff(List<Integer> list, TimeUnit timeUnit) {
            this.backoffTimes = list;
            this.timeUnit = timeUnit;
        }

        protected abstract long getNextBackoffInMillis();

        protected final long getBackoffForAttempt() {
            if (this.numberOfAttempts >= this.backoffTimes.size()) {
                return this.backoffTimes.get(this.backoffTimes.size() - 1).intValue();
            }
            int n = this.backoffTimes.get(this.numberOfAttempts);
            ++this.numberOfAttempts;
            return this.timeUnit.toMillis(n);
        }
    }

    static class RootResultFetcher {
        private final Matcher<Root> selector;
        private final ActiveRootLister activeRootLister;

        public RootResultFetcher(ActiveRootLister activeRootLister, AtomicReference<Matcher<Root>> atomicReference) {
            this.activeRootLister = activeRootLister;
            this.selector = atomicReference.get();
        }

        public RootResults fetch() {
            List<Root> list = this.activeRootLister.listActiveRoots();
            ArrayList<Root> arrayList = Lists.newArrayList();
            for (Root root : list) {
                if (!this.selector.matches((Object)root)) continue;
                arrayList.add(root);
            }
            return new RootResults(list, arrayList, this.selector);
        }
    }

    private static class RootResults {
        private final List<Root> allRoots;
        private final List<Root> pickedRoots;
        private final Matcher<Root> rootSelector;

        private RootResults(List<Root> list, List<Root> list2, Matcher<Root> matcher) {
            this.allRoots = list;
            this.pickedRoots = list2;
            this.rootSelector = matcher;
        }

        private static boolean isTopmostRoot(Root root, Root root2) {
            return root2.getWindowLayoutParams().get().type > root.getWindowLayoutParams().get().type;
        }

        public State getState() {
            if (this.allRoots.isEmpty()) {
                return State.NO_ROOTS_PRESENT;
            }
            if (this.pickedRoots.isEmpty()) {
                return State.NO_ROOTS_PICKED;
            }
            if (this.pickedRoots.size() >= 1) {
                return State.ROOTS_PICKED;
            }
            return State.NO_ROOTS_PICKED;
        }

        private Root getRootFromMultipleRoots() {
            Root root = this.pickedRoots.get(0);
            if (this.pickedRoots.size() >= 1) {
                for (Root root2 : this.pickedRoots) {
                    if (RootMatchers.isDialog().matches((Object)root2)) {
                        return root2;
                    }
                    if (!RootResults.isTopmostRoot(root, root2)) continue;
                    root = root2;
                }
            }
            return root;
        }

        public Root getPickedRoot() {
            if (this.pickedRoots.size() > 1) {
                LogUtil.logDebugWithProcess((String)TAG, (String)"Multiple root windows detected: %s", (Object[])new Object[]{this.pickedRoots});
                return this.getRootFromMultipleRoots();
            }
            return this.pickedRoots.get(0);
        }

        static enum State {
            NO_ROOTS_PRESENT,
            NO_ROOTS_PICKED,
            ROOTS_PICKED;

        }
    }
}

