/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

public final class DefaultFailureHandler
implements FailureHandler {
    private final Context appContext;

    public DefaultFailureHandler(Context context) {
        this.appContext = Preconditions.checkNotNull(context);
    }

    @Override
    public void handle(Throwable throwable, Matcher<View> matcher) {
        if (throwable instanceof EspressoException || throwable instanceof AssertionFailedError || throwable instanceof AssertionError) {
            Throwables.throwIfUnchecked(this.getUserFriendlyError(throwable, matcher));
            throw new RuntimeException(this.getUserFriendlyError(throwable, matcher));
        }
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    private Throwable getUserFriendlyError(Throwable object, Matcher<View> matcher) {
        if (object instanceof PerformException) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!DefaultFailureHandler.isAnimationAndTransitionDisabled(this.appContext)) {
                stringBuilder.append("Animations or transitions are enabled on the target device.\nFor more info check: http://goo.gl/qVu1yV\n\n");
            }
            stringBuilder.append(matcher.toString());
            throw new PerformException.Builder().from((PerformException)object).withViewDescription(stringBuilder.toString()).build();
        }
        if (object instanceof AssertionError) {
            object = new AssertionFailedWithCauseError(object.getMessage(), (Throwable)object);
        }
        object.setStackTrace(Thread.currentThread().getStackTrace());
        return object;
    }

    private static boolean isAnimationAndTransitionDisabled(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        boolean bl = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getTransitionAnimationScale(contentResolver));
        boolean bl2 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getWindowAnimationScale(contentResolver));
        boolean bl3 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getAnimatorDurationScale(contentResolver));
        return bl && bl2 && bl3;
    }

    private static boolean isEqualToZero(float f) {
        return Float.compare(Math.abs(f), 0.0f) == 0;
    }

    private static float getTransitionAnimationScale(ContentResolver contentResolver) {
        return DefaultFailureHandler.getSetting(contentResolver, "transition_animation_scale", "transition_animation_scale");
    }

    private static float getWindowAnimationScale(ContentResolver contentResolver) {
        return DefaultFailureHandler.getSetting(contentResolver, "window_animation_scale", "window_animation_scale");
    }

    private static float getAnimatorDurationScale(ContentResolver contentResolver) {
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            return DefaultFailureHandler.getSetting(contentResolver, "animator_duration_scale", "animator_duration_scale");
        }
        return 0.0f;
    }

    private static float getSetting(ContentResolver contentResolver, String string, String string2) {
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            return DefaultFailureHandler.getGlobalSetting(contentResolver, string);
        }
        return DefaultFailureHandler.getSystemSetting(contentResolver, string2);
    }

    private static boolean isJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private static float getGlobalSetting(ContentResolver contentResolver, String string) {
        try {
            return Settings.Global.getFloat((ContentResolver)contentResolver, (String)string);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    private static float getSystemSetting(ContentResolver contentResolver, String string) {
        try {
            return Settings.System.getFloat((ContentResolver)contentResolver, (String)string);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    private static final class AssertionFailedWithCauseError
    extends AssertionFailedError {
        public AssertionFailedWithCauseError(String string, Throwable throwable) {
            super(string);
            this.initCause(throwable);
        }
    }
}

