/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.test.InstrumentationRegistry;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.AsyncTaskPoolMonitor;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.Default;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.InputManagerEventInjectionStrategy;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.base.NoopRunnableIdleNotifier;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.base.WindowManagerEventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ThreadFactoryBuilder;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BaseLayerModule {
    public ActivityLifecycleMonitor provideLifecycleMonitor() {
        return ActivityLifecycleMonitorRegistry.getInstance();
    }

    public Context provideTargetContext() {
        return InstrumentationRegistry.getTargetContext();
    }

    public Looper provideMainLooper() {
        return Looper.getMainLooper();
    }

    @CompatAsyncTask
    public IdleNotifier<Runnable> provideCompatAsyncTaskMonitor(ThreadPoolExecutorExtractor threadPoolExecutorExtractor) {
        Optional<ThreadPoolExecutor> optional = threadPoolExecutorExtractor.getCompatAsyncTaskThreadPool();
        if (optional.isPresent()) {
            return new AsyncTaskPoolMonitor(optional.get()).asIdleNotifier();
        }
        return new NoopRunnableIdleNotifier();
    }

    @MainThread
    public Executor provideMainThreadExecutor(Looper looper) {
        final Handler handler = new Handler(looper);
        return new Executor(this){

            @Override
            public void execute(Runnable runnable) {
                handler.post(runnable);
            }
        };
    }

    public IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> provideDynamicNotifer(IdlingResourceRegistry idlingResourceRegistry) {
        idlingResourceRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
        return idlingResourceRegistry.asIdleNotifier();
    }

    @SdkAsyncTask
    public IdleNotifier<Runnable> provideSdkAsyncTaskMonitor(ThreadPoolExecutorExtractor threadPoolExecutorExtractor) {
        return new AsyncTaskPoolMonitor(threadPoolExecutorExtractor.getAsyncTaskThreadPool()).asIdleNotifier();
    }

    public ActiveRootLister provideActiveRootLister(RootsOracle rootsOracle) {
        return rootsOracle;
    }

    public EventInjector provideEventInjector() {
        int n = Build.VERSION.SDK_INT;
        EventInjectionStrategy eventInjectionStrategy = null;
        if (n >= 16) {
            InputManagerEventInjectionStrategy inputManagerEventInjectionStrategy = new InputManagerEventInjectionStrategy();
            inputManagerEventInjectionStrategy.initialize();
            eventInjectionStrategy = inputManagerEventInjectionStrategy;
        } else if (n >= 7) {
            WindowManagerEventInjectionStrategy windowManagerEventInjectionStrategy = new WindowManagerEventInjectionStrategy();
            windowManagerEventInjectionStrategy.initialize();
            eventInjectionStrategy = windowManagerEventInjectionStrategy;
        } else {
            throw new RuntimeException(new StringBuilder(68).append("API Level 6 and below is not supported. You are running: ").append(n).toString());
        }
        return new EventInjector(eventInjectionStrategy);
    }

    FailureHandler provideFailureHandler(FailureHandlerHolder failureHandlerHolder) {
        return failureHandlerHolder.get();
    }

    public ListeningExecutorService provideRemoteExecutor() {
        return MoreExecutors.listeningDecorator(new ThreadPoolExecutor(0, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Espresso Remote #%d").build()));
    }

    @Default
    FailureHandler provideFailureHander() {
        return new DefaultFailureHandler(InstrumentationRegistry.getTargetContext());
    }

    public static class FailureHandlerHolder {
        private final AtomicReference<FailureHandler> holder;

        public FailureHandlerHolder(@Default FailureHandler failureHandler) {
            this.holder = new AtomicReference<FailureHandler>(failureHandler);
        }

        public void update(FailureHandler failureHandler) {
            this.holder.set(failureHandler);
        }

        public FailureHandler get() {
            return this.holder.get();
        }
    }
}

