/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public enum Tap implements Tapper
{
    SINGLE{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2) {
            return this.sendTap(uiController, fArray, fArray2, 0, 0);
        }

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2, int n, int n2) {
            Tapper.Status status = Tap.sendSingleTap(uiController, fArray, fArray2, n, n2);
            if (Tapper.Status.SUCCESS == status) {
                long l = (long)((float)ViewConfiguration.getTapTimeout() * 1.5f);
                uiController.loopMainThreadForAtLeast(l);
            }
            return status;
        }
    }
    ,
    LONG{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2) {
            return this.sendTap(uiController, fArray, fArray2, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2, int n, int n2) {
            Preconditions.checkNotNull(uiController);
            Preconditions.checkNotNull(fArray);
            Preconditions.checkNotNull(fArray2);
            MotionEvent motionEvent = MotionEvents.sendDown((UiController)uiController, (float[])fArray, (float[])fArray2, (int)n, (int)n2).down;
            try {
                long l = (long)((float)ViewConfiguration.getLongPressTimeout() * 1.5f);
                uiController.loopMainThreadForAtLeast(l);
                if (!MotionEvents.sendUp(uiController, motionEvent)) {
                    MotionEvents.sendCancel(uiController, motionEvent);
                    Tapper.Status status = Tapper.Status.FAILURE;
                    return status;
                }
            }
            finally {
                motionEvent.recycle();
                motionEvent = null;
            }
            return Tapper.Status.SUCCESS;
        }
    }
    ,
    DOUBLE{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2) {
            return this.sendTap(uiController, fArray, fArray2, 0, 0);
        }

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] fArray, float[] fArray2, int n, int n2) {
            Tapper.Status status;
            Preconditions.checkNotNull(uiController);
            Preconditions.checkNotNull(fArray);
            Preconditions.checkNotNull(fArray2);
            Tapper.Status status2 = Tap.sendSingleTap(uiController, fArray, fArray2, n, n2);
            if (status2 == Tapper.Status.FAILURE) {
                return Tapper.Status.FAILURE;
            }
            if (0 < DOUBLE_TAP_MIN_TIMEOUT) {
                uiController.loopMainThreadForAtLeast(DOUBLE_TAP_MIN_TIMEOUT);
            }
            if ((status = Tap.sendSingleTap(uiController, fArray, fArray2, n, n2)) == Tapper.Status.FAILURE) {
                return Tapper.Status.FAILURE;
            }
            if (status == Tapper.Status.WARNING || status2 == Tapper.Status.WARNING) {
                return Tapper.Status.WARNING;
            }
            return Tapper.Status.SUCCESS;
        }
    };

    private static final String TAG;
    private static final int DOUBLE_TAP_MIN_TIMEOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tapper.Status sendSingleTap(UiController uiController, float[] fArray, float[] fArray2, int n, int n2) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        MotionEvents.DownResultHolder downResultHolder = MotionEvents.sendDown(uiController, fArray, fArray2, n, n2);
        try {
            if (!MotionEvents.sendUp(uiController, downResultHolder.down)) {
                Log.d((String)TAG, (String)"Injection of up event as part of the click failed. Send cancel event.");
                MotionEvents.sendCancel(uiController, downResultHolder.down);
                Tapper.Status status = Tapper.Status.FAILURE;
                return status;
            }
        }
        finally {
            downResultHolder.down.recycle();
        }
        return downResultHolder.longPress ? Tapper.Status.WARNING : Tapper.Status.SUCCESS;
    }

    static {
        TAG = Tap.class.getSimpleName();
        int n = 0;
        if (Build.VERSION.SDK_INT > 18) {
            try {
                Method method = ViewConfiguration.class.getDeclaredMethod("getDoubleTapMinTime", new Class[0]);
                n = (Integer)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.w((String)TAG, (String)"Expected to find getDoubleTapMinTime", (Throwable)noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.w((String)TAG, (String)"Unable to query double tap min time!", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)TAG, (String)"Unable to query double tap min time!", (Throwable)illegalAccessException);
            }
        }
        DOUBLE_TAP_MIN_TIMEOUT = n;
    }
}

