/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.DataInteraction;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.GraphHolder;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Espresso {
    private static final BaseLayerComponent BASE = GraphHolder.baseLayer();
    private static final IdlingResourceRegistry baseRegistry = BASE.idlingResourceRegistry();
    private static final Matcher<View> OVERFLOW_BUTTON_MATCHER = Matchers.anyOf((Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withContentDescription("More options")), (Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withClassName((Matcher<String>)Matchers.endsWith((String)"OverflowMenuButton"))));

    private Espresso() {
    }

    public static ViewInteraction onView(Matcher<View> matcher) {
        return BASE.plus(new ViewInteractionModule(matcher)).viewInteraction();
    }

    public static DataInteraction onData(Matcher<? extends Object> matcher) {
        return new DataInteraction(matcher);
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper) {
        Espresso.registerLooperAsIdlingResource(looper, false);
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper, boolean bl) {
        IdlingRegistry.getInstance().registerLooperAsIdlingResource(looper);
        baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
    }

    @Deprecated
    public static boolean registerIdlingResources(IdlingResource ... idlingResourceArray) {
        if (IdlingRegistry.getInstance().register(idlingResourceArray)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        return idlingResourceArray.length == 0;
    }

    @Deprecated
    public static boolean unregisterIdlingResources(IdlingResource ... idlingResourceArray) {
        if (IdlingRegistry.getInstance().unregister(idlingResourceArray)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        return idlingResourceArray.length == 0;
    }

    @Deprecated
    public static List<IdlingResource> getIdlingResources() {
        return baseRegistry.getResources();
    }

    public static void setFailureHandler(FailureHandler failureHandler) {
        BASE.failureHolder().update(Preconditions.checkNotNull(failureHandler));
    }

    public static void closeSoftKeyboard() {
        Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.closeSoftKeyboard());
    }

    public static void openContextualActionModeOverflowMenu() {
        Espresso.onView(ViewMatchers.isRoot()).perform(new TransitionBridgingViewAction());
        Espresso.onView(OVERFLOW_BUTTON_MATCHER).perform(ViewActions.click(ViewActions.pressBack()));
    }

    public static void pressBack() {
        Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressBack());
    }

    public static void pressBackUnconditionally() {
        Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressBackUnconditionally());
    }

    public static void openActionBarOverflowOrOptionsMenu(Context context) {
        if (context.getApplicationInfo().targetSdkVersion < 11) {
            Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressMenuKey());
        } else if (Espresso.hasVirtualOverflowButton(context)) {
            Espresso.onView(ViewMatchers.isRoot()).perform(new TransitionBridgingViewAction());
            Espresso.onView(OVERFLOW_BUTTON_MATCHER).perform(ViewActions.click());
        } else {
            Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressMenuKey());
        }
    }

    public static <T> T onIdle(Callable<T> callable) {
        Executor executor = BASE.mainThreadExecutor();
        ListenableFutureTask<Object> listenableFutureTask = ListenableFutureTask.create(new Runnable(){

            @Override
            public void run() {
                BASE.uiController().loopMainThreadUntilIdle();
            }
        }, null);
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        listenableFutureTask.addListener(futureTask, executor);
        executor.execute(listenableFutureTask);
        try {
            listenableFutureTask.get();
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof AppNotIdleException) {
                throw (AppNotIdleException)executionException.getCause();
            }
            throw new RuntimeException(executionException);
        }
    }

    public static void onIdle() {
        Espresso.onIdle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
    }

    private static boolean hasVirtualOverflowButton(Context context) {
        if (Build.VERSION.SDK_INT < 14) {
            return Build.VERSION.SDK_INT >= 11;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static class TransitionBridgingViewAction
    implements ViewAction {
        private TransitionBridgingViewAction() {
        }

        @Override
        public void perform(UiController uiController, View view) {
            for (int i = 0; this.isTransitioningBetweenActionBars(view) && i < 100; ++i) {
                uiController.loopMainThreadForAtLeast(50L);
            }
        }

        @Override
        public String getDescription() {
            return "Handle transition between action bar and action bar context.";
        }

        @Override
        public Matcher<View> getConstraints() {
            return ViewMatchers.isRoot();
        }

        private boolean isTransitioningBetweenActionBars(View view) {
            int n = 0;
            for (View view2 : TreeIterables.breadthFirstViewTraversal(view)) {
                if (!OVERFLOW_BUTTON_MATCHER.matches((Object)view2)) continue;
                ++n;
            }
            return n > 1;
        }
    }
}

