/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package androidx.test.espresso.remote;

import static com.google.protobuf.ByteString.copyFrom;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.protobuf.ByteString;

/** Convert a {@link Parcelable} into its {@link ByteString} representation. */
final class ParcelableToByteStringConverter implements Converter<Parcelable, ByteString> {

  /**
   * Convert a {@link Parcelable} into its {@link ByteString} representation.
   *
   * @param parcelable to convert into a {@link ByteString}
   */
  @Override
  public ByteString convert(@NonNull Parcelable parcelable) {
    Parcel parcel = null;
    try {
      parcel = Parcel.obtain();
      parcelable.writeToParcel(parcel, 0);
      return copyFrom(parcel.marshall());
    } finally {
      if (parcel != null) {
        parcel.recycle();
      }
    }
  }
}
