/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.WebView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.test.annotation.Beta;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.BoundedMatcher;
import androidx.test.espresso.matcher.HasBackgroundMatcher;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public final class ViewMatchers {
    private ViewMatchers() {
    }

    public static Matcher<View> isAssignableFrom(Class<? extends View> clazz) {
        return new IsAssignableFromMatcher(clazz);
    }

    public static Matcher<View> withClassName(Matcher<String> matcher) {
        return new WithClassNameMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> isDisplayed() {
        return new IsDisplayedMatcher();
    }

    public static Matcher<View> isCompletelyDisplayed() {
        return ViewMatchers.isDisplayingAtLeast(100);
    }

    public static Matcher<View> isDisplayingAtLeast(int n) {
        Preconditions.checkState(n <= 100, "Cannot have over 100 percent: %s", n);
        Preconditions.checkState(n > 0, "Must have a positive, non-zero value: %s", n);
        return new IsDisplayingAtLeastMatcher(n);
    }

    public static Matcher<View> isEnabled() {
        return new IsEnabledMatcher();
    }

    public static Matcher<View> isFocusable() {
        return new IsFocusableMatcher();
    }

    public static Matcher<View> hasFocus() {
        return new HasFocusMatcher();
    }

    public static Matcher<View> isSelected() {
        return new IsSelectedMatcher();
    }

    public static Matcher<View> hasSibling(Matcher<View> matcher) {
        return new HasSiblingMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withContentDescription(int n) {
        return new WithContentDescriptionFromIdMatcher(n);
    }

    public static Matcher<View> withContentDescription(String string) {
        return ViewMatchers.withContentDescription((Matcher<? extends CharSequence>)Matchers.is((Object)string));
    }

    public static Matcher<View> withContentDescription(Matcher<? extends CharSequence> matcher) {
        return new WithContentDescriptionMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withId(int n) {
        return ViewMatchers.withId((Matcher<Integer>)Matchers.is((Object)n));
    }

    public static Matcher<View> withId(Matcher<Integer> matcher) {
        return new WithIdMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withResourceName(String string) {
        return ViewMatchers.withResourceName((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<View> withResourceName(Matcher<String> matcher) {
        return new WithResourceNameMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withTagKey(int n) {
        return ViewMatchers.withTagKey(n, (Matcher<Object>)Matchers.notNullValue());
    }

    public static Matcher<View> withTagKey(int n, Matcher<Object> matcher) {
        return new WithTagKeyMatcher(n, Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withTagValue(Matcher<Object> matcher) {
        return new WithTagValueMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withText(String string) {
        return ViewMatchers.withText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<View> withText(Matcher<String> matcher) {
        return new WithTextMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withText(int n) {
        return new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_TEXT);
    }

    public static Matcher<View> withSubstring(String string) {
        return ViewMatchers.withText((Matcher<String>)Matchers.containsString((String)string));
    }

    public static Matcher<View> withHint(String string) {
        return ViewMatchers.withHint((Matcher<String>)Matchers.is((Object)Preconditions.checkNotNull(string)));
    }

    public static Matcher<View> withHint(Matcher<String> matcher) {
        return new WithHintMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withHint(int n) {
        return new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_HINT);
    }

    public static Matcher<View> isChecked() {
        return ViewMatchers.withCheckBoxState((Matcher<Boolean>)Matchers.is((Object)true));
    }

    public static Matcher<View> isNotChecked() {
        return ViewMatchers.withCheckBoxState((Matcher<Boolean>)Matchers.is((Object)false));
    }

    private static <E extends View> Matcher<View> withCheckBoxState(Matcher<Boolean> matcher) {
        return new WithCheckBoxStateMatcher(matcher);
    }

    public static Matcher<View> hasContentDescription() {
        return new HasContentDescriptionMatcher();
    }

    public static Matcher<View> hasDescendant(Matcher<View> matcher) {
        return new HasDescendantMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> isClickable() {
        return new IsClickableMatcher();
    }

    public static Matcher<View> isDescendantOfA(Matcher<View> matcher) {
        return new IsDescendantOfAMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withEffectiveVisibility(Visibility visibility) {
        return new WithEffectiveVisibilityMatcher(visibility);
    }

    public static Matcher<View> withAlpha(float f) {
        return new WithAlphaMatcher(f);
    }

    public static Matcher<View> withParent(Matcher<View> matcher) {
        return new WithParentMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withChild(Matcher<View> matcher) {
        return new WithChildMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> hasChildCount(int n) {
        return new HasChildCountMatcher(n);
    }

    public static Matcher<View> hasMinimumChildCount(int n) {
        return new HasMinimumChildCountMatcher(n);
    }

    public static Matcher<View> isRoot() {
        return new IsRootMatcher();
    }

    public static Matcher<View> supportsInputMethods() {
        return new SupportsInputMethodsMatcher();
    }

    public static Matcher<View> hasImeAction(int n) {
        return ViewMatchers.hasImeAction((Matcher<Integer>)Matchers.is((Object)n));
    }

    public static Matcher<View> hasImeAction(Matcher<Integer> matcher) {
        return new HasImeActionMatcher(matcher);
    }

    public static Matcher<View> hasLinks() {
        return new HasLinksMatcher();
    }

    public static <T> void assertThat(T t, Matcher<T> matcher) {
        ViewMatchers.assertThat("", t, matcher);
    }

    public static <T> void assertThat(String string, T t, Matcher<T> matcher) {
        if (!matcher.matches(t)) {
            StringDescription stringDescription = new StringDescription();
            stringDescription.appendText(string).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     Got: ");
            if (t instanceof View) {
                stringDescription.appendValue((Object)HumanReadables.describe((View)t));
            } else {
                stringDescription.appendValue(t);
            }
            stringDescription.appendText("\n");
            throw new AssertionFailedError(stringDescription.toString());
        }
    }

    public static Matcher<View> withSpinnerText(int n) {
        return new WithSpinnerTextIdMatcher(n);
    }

    public static Matcher<View> withSpinnerText(Matcher<String> matcher) {
        return new WithSpinnerTextMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> withSpinnerText(String string) {
        return ViewMatchers.withSpinnerText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<View> isJavascriptEnabled() {
        return new IsJavascriptEnabledMatcher();
    }

    public static Matcher<View> hasErrorText(Matcher<String> matcher) {
        return new HasErrorTextMatcher(Preconditions.checkNotNull(matcher));
    }

    public static Matcher<View> hasErrorText(String string) {
        return ViewMatchers.hasErrorText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<View> withInputType(int n) {
        return new WithInputTypeMatcher(n);
    }

    public static Matcher<View> withParentIndex(int n) {
        Preconditions.checkArgument(n >= 0, "Index %s must be >= 0", n);
        return new WithParentIndexMatcher(n);
    }

    @Beta
    public static Matcher<View> hasBackground(int n) {
        return new HasBackgroundMatcher(n);
    }

    @Beta
    public static Matcher<View> hasTextColor(final int n) {
        return new BoundedMatcher<View, TextView>(TextView.class){
            private Context context;

            @Override
            protected boolean matchesSafely(TextView textView) {
                this.context = textView.getContext();
                int n3 = textView.getCurrentTextColor();
                int n2 = Build.VERSION.SDK_INT <= 22 ? this.context.getResources().getColor(n) : this.context.getColor(n);
                return n3 == n2;
            }

            public void describeTo(Description description) {
                String string = String.valueOf(n);
                if (this.context != null) {
                    string = this.context.getResources().getResourceName(n);
                }
                String string2 = String.valueOf(string);
                description.appendText(string2.length() != 0 ? "has color with ID ".concat(string2) : new String("has color with ID "));
            }
        };
    }

    static final class WithParentIndexMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int index;

        @RemoteMsgConstructor
        private WithParentIndexMatcher(int n) {
            this.index = n;
        }

        public void describeTo(Description description) {
            int n = this.index;
            description.appendText(new StringBuilder(30).append("with parent index: ").append(n).toString());
        }

        public boolean matchesSafely(View view) {
            ViewParent viewParent = view.getParent();
            return viewParent instanceof ViewGroup && ((ViewGroup)viewParent).getChildCount() > this.index && ((ViewGroup)viewParent).getChildAt(this.index) == view;
        }
    }

    static final class WithInputTypeMatcher
    extends BoundedMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private int inputType;

        @RemoteMsgConstructor
        private WithInputTypeMatcher(int n) {
            super(EditText.class);
            this.inputType = n;
        }

        public void describeTo(Description description) {
            description.appendText("is view input type equal to: ");
            description.appendText(Integer.toString(this.inputType));
        }

        @Override
        protected boolean matchesSafely(EditText editText) {
            return editText.getInputType() == this.inputType;
        }
    }

    static final class HasErrorTextMatcher
    extends BoundedMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private HasErrorTextMatcher(Matcher<String> matcher) {
            super(EditText.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with error: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(EditText editText) {
            return this.stringMatcher.matches((Object)editText.getError());
        }
    }

    static final class IsJavascriptEnabledMatcher
    extends BoundedMatcher<View, WebView> {
        @RemoteMsgConstructor
        private IsJavascriptEnabledMatcher() {
            super(WebView.class);
        }

        public void describeTo(Description description) {
            description.appendText("WebView with JS enabled");
        }

        @Override
        public boolean matchesSafely(WebView webView) {
            return webView.getSettings().getJavaScriptEnabled();
        }
    }

    static final class WithSpinnerTextMatcher
    extends BoundedMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithSpinnerTextMatcher(Matcher<String> matcher) {
            super(Spinner.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with text: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(Spinner spinner) {
            return this.stringMatcher.matches((Object)spinner.getSelectedItem().toString());
        }
    }

    static final class WithSpinnerTextIdMatcher
    extends BoundedMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithSpinnerTextIdMatcher(int n) {
            super(Spinner.class);
            this.resourceId = n;
        }

        public void describeTo(Description description) {
            description.appendText("with string from resource id: ");
            description.appendValue((Object)this.resourceId);
            if (null != this.resourceName) {
                description.appendText("[");
                description.appendText(this.resourceName);
                description.appendText("]");
            }
            if (null != this.expectedText) {
                description.appendText(" value: ");
                description.appendText(this.expectedText);
            }
        }

        @Override
        public boolean matchesSafely(Spinner spinner) {
            if (null == this.expectedText) {
                try {
                    this.expectedText = spinner.getResources().getString(this.resourceId);
                    this.resourceName = spinner.getResources().getResourceEntryName(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (null != this.expectedText) {
                return this.expectedText.equals(spinner.getSelectedItem().toString());
            }
            return false;
        }
    }

    static final class HasLinksMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgConstructor
        private HasLinksMatcher() {
            super(TextView.class);
        }

        public void describeTo(Description description) {
            description.appendText("has links");
        }

        @Override
        public boolean matchesSafely(TextView textView) {
            return textView.getUrls().length > 0;
        }
    }

    static final class HasImeActionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<Integer> imeActionMatcher;

        @RemoteMsgConstructor
        private HasImeActionMatcher(Matcher<Integer> matcher) {
            this.imeActionMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has ime action: ");
            this.imeActionMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            EditorInfo editorInfo = new EditorInfo();
            InputConnection inputConnection = view.onCreateInputConnection(editorInfo);
            if (inputConnection == null) {
                return false;
            }
            int n = editorInfo.actionId != 0 ? editorInfo.actionId : editorInfo.imeOptions & 0xFF;
            return this.imeActionMatcher.matches((Object)n);
        }
    }

    static final class SupportsInputMethodsMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private SupportsInputMethodsMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("supports input methods");
        }

        public boolean matchesSafely(View view) {
            return view.onCreateInputConnection(new EditorInfo()) != null;
        }
    }

    static final class IsRootMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsRootMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is a root view.");
        }

        public boolean matchesSafely(View view) {
            return view.getRootView().equals(view);
        }
    }

    static final class HasMinimumChildCountMatcher
    extends BoundedMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int minChildCount;

        @RemoteMsgConstructor
        private HasMinimumChildCountMatcher(int n) {
            super(ViewGroup.class);
            this.minChildCount = n;
        }

        public void describeTo(Description description) {
            description.appendText("has minimum child count: ").appendValue((Object)this.minChildCount);
        }

        @Override
        public boolean matchesSafely(ViewGroup viewGroup) {
            return viewGroup.getChildCount() >= this.minChildCount;
        }
    }

    static final class HasChildCountMatcher
    extends BoundedMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int childCount;

        @RemoteMsgConstructor
        private HasChildCountMatcher(int n) {
            super(ViewGroup.class);
            this.childCount = n;
        }

        public void describeTo(Description description) {
            description.appendText("has child count: ").appendValue((Object)this.childCount);
        }

        @Override
        public boolean matchesSafely(ViewGroup viewGroup) {
            return viewGroup.getChildCount() == this.childCount;
        }
    }

    static final class WithChildMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<View> childMatcher;

        @RemoteMsgConstructor
        private WithChildMatcher(Matcher<View> matcher) {
            this.childMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has child: ");
            this.childMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            if (!(view instanceof ViewGroup)) {
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (!this.childMatcher.matches((Object)viewGroup.getChildAt(i))) continue;
                return true;
            }
            return false;
        }
    }

    static final class WithParentMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<View> parentMatcher;

        @RemoteMsgConstructor
        private WithParentMatcher(Matcher<View> matcher) {
            this.parentMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has parent matching: ");
            this.parentMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.parentMatcher.matches((Object)view.getParent());
        }
    }

    static final class WithAlphaMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final float alpha;

        @RemoteMsgConstructor
        private WithAlphaMatcher(float f) {
            this.alpha = f;
        }

        public void describeTo(Description description) {
            description.appendText("has alpha: ").appendValue((Object)Float.valueOf(this.alpha));
        }

        public boolean matchesSafely(View view) {
            return view.getAlpha() == this.alpha;
        }
    }

    static final class WithEffectiveVisibilityMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Visibility visibility;

        @RemoteMsgConstructor
        private WithEffectiveVisibilityMatcher(Visibility visibility) {
            this.visibility = visibility;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("view has effective visibility=%s", new Object[]{this.visibility}));
        }

        public boolean matchesSafely(View view) {
            if (this.visibility.getValue() == 0) {
                if (view.getVisibility() != this.visibility.getValue()) {
                    return false;
                }
                while (view.getParent() != null && view.getParent() instanceof View) {
                    if ((view = (View)view.getParent()).getVisibility() == this.visibility.getValue()) continue;
                    return false;
                }
                return true;
            }
            if (view.getVisibility() == this.visibility.getValue()) {
                return true;
            }
            while (view.getParent() != null && view.getParent() instanceof View) {
                if ((view = (View)view.getParent()).getVisibility() != this.visibility.getValue()) continue;
                return true;
            }
            return false;
        }
    }

    static final class IsDescendantOfAMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<View> ancestorMatcher;

        @RemoteMsgConstructor
        private IsDescendantOfAMatcher(Matcher<View> matcher) {
            this.ancestorMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("is descendant of a: ");
            this.ancestorMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.checkAncestors(view.getParent(), this.ancestorMatcher);
        }

        private boolean checkAncestors(ViewParent viewParent, Matcher<View> matcher) {
            if (!(viewParent instanceof View)) {
                return false;
            }
            if (matcher.matches((Object)viewParent)) {
                return true;
            }
            return this.checkAncestors(viewParent.getParent(), matcher);
        }
    }

    static final class IsClickableMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsClickableMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is clickable");
        }

        public boolean matchesSafely(View view) {
            return view.isClickable();
        }
    }

    static final class HasDescendantMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<View> descendantMatcher;

        @RemoteMsgConstructor
        private HasDescendantMatcher(Matcher<View> matcher) {
            this.descendantMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has descendant: ");
            this.descendantMatcher.describeTo(description);
        }

        public boolean matchesSafely(final View view) {
            Predicate<View> predicate = new Predicate<View>(){

                @Override
                public boolean apply(View view2) {
                    return view2 != view && HasDescendantMatcher.this.descendantMatcher.matches((Object)view2);
                }
            };
            Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
            return iterator.hasNext();
        }
    }

    static final class HasContentDescriptionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private HasContentDescriptionMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("has content description");
        }

        public boolean matchesSafely(View view) {
            return view.getContentDescription() != null;
        }
    }

    static final class WithCheckBoxStateMatcher<E extends View>
    extends BoundedMatcher<View, E> {
        @RemoteMsgField(order=0)
        private final Matcher<Boolean> checkStateMatcher;

        @RemoteMsgConstructor
        private WithCheckBoxStateMatcher(Matcher<Boolean> matcher) {
            super(View.class, Checkable.class, new Class[0]);
            this.checkStateMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with checkbox state: ");
            this.checkStateMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(E e) {
            return this.checkStateMatcher.matches((Object)((Checkable)e).isChecked());
        }
    }

    static final class WithHintMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithHintMatcher(Matcher<String> matcher) {
            super(TextView.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with hint: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(TextView textView) {
            return this.stringMatcher.matches((Object)textView.getHint());
        }
    }

    static final class WithCharSequenceMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        @RemoteMsgField(order=1)
        private final TextViewMethod method;
        private String resourceName;
        private String expectedText;

        @RemoteMsgConstructor
        private WithCharSequenceMatcher(int n, TextViewMethod textViewMethod) {
            super(TextView.class);
            this.resourceId = n;
            this.method = textViewMethod;
        }

        public void describeTo(Description description) {
            description.appendText("with string from resource id: ").appendValue((Object)this.resourceId);
            if (null != this.resourceName) {
                description.appendText("[").appendText(this.resourceName).appendText("]");
            }
            if (null != this.expectedText) {
                description.appendText(" value: ").appendText(this.expectedText);
            }
        }

        @Override
        public boolean matchesSafely(TextView textView) {
            CharSequence charSequence;
            if (null == this.expectedText) {
                try {
                    this.expectedText = textView.getResources().getString(this.resourceId);
                    this.resourceName = textView.getResources().getResourceEntryName(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            switch (this.method) {
                case GET_TEXT: {
                    charSequence = textView.getText();
                    break;
                }
                case GET_HINT: {
                    charSequence = textView.getHint();
                    break;
                }
                default: {
                    String string = String.valueOf(this.method.toString());
                    throw new IllegalStateException(string.length() != 0 ? "Unexpected TextView method: ".concat(string) : new String("Unexpected TextView method: "));
                }
            }
            return null != this.expectedText && null != charSequence && this.expectedText.equals(charSequence.toString());
        }

        private static enum TextViewMethod {
            GET_TEXT,
            GET_HINT;

        }
    }

    static final class WithTagValueMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<Object> tagValueMatcher;

        @RemoteMsgConstructor
        private WithTagValueMatcher(Matcher<Object> matcher) {
            this.tagValueMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with tag value: ");
            this.tagValueMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.tagValueMatcher.matches(view.getTag());
        }
    }

    static final class WithContentDescriptionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<? extends CharSequence> charSequenceMatcher;

        @RemoteMsgConstructor
        private WithContentDescriptionMatcher(Matcher<? extends CharSequence> matcher) {
            this.charSequenceMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with content description: ");
            this.charSequenceMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.charSequenceMatcher.matches((Object)view.getContentDescription());
        }
    }

    static final class WithContentDescriptionFromIdMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithContentDescriptionFromIdMatcher(int n) {
            this.resourceId = n;
        }

        public void describeTo(Description description) {
            description.appendText("with content description from resource id: ");
            description.appendValue((Object)this.resourceId);
            if (null != this.resourceName) {
                description.appendText("[");
                description.appendText(this.resourceName);
                description.appendText("]");
            }
            if (null != this.expectedText) {
                description.appendText(" value: ");
                description.appendText(this.expectedText);
            }
        }

        public boolean matchesSafely(View view) {
            if (null == this.expectedText) {
                try {
                    this.expectedText = view.getResources().getString(this.resourceId);
                    this.resourceName = view.getResources().getResourceEntryName(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (null != this.expectedText && null != view.getContentDescription()) {
                return this.expectedText.equals(view.getContentDescription().toString());
            }
            return false;
        }
    }

    static final class HasSiblingMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<View> siblingMatcher;

        @RemoteMsgConstructor
        private HasSiblingMatcher(Matcher<View> matcher) {
            this.siblingMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has sibling: ");
            this.siblingMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            ViewParent viewParent = view.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (!this.siblingMatcher.matches((Object)viewGroup.getChildAt(i))) continue;
                return true;
            }
            return false;
        }
    }

    static final class IsSelectedMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsSelectedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is selected");
        }

        public boolean matchesSafely(View view) {
            return view.isSelected();
        }
    }

    static final class HasFocusMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private HasFocusMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("has focus on the screen to the user");
        }

        public boolean matchesSafely(View view) {
            return view.hasFocus();
        }
    }

    static final class IsFocusableMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsFocusableMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is focusable");
        }

        public boolean matchesSafely(View view) {
            return view.isFocusable();
        }
    }

    static final class IsEnabledMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsEnabledMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is enabled");
        }

        public boolean matchesSafely(View view) {
            return view.isEnabled();
        }
    }

    static final class IsDisplayingAtLeastMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        final int areaPercentage;

        @RemoteMsgConstructor
        private IsDisplayingAtLeastMatcher(int n) {
            this.areaPercentage = n;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("at least %s percent of the view's area is displayed to the user.", this.areaPercentage));
        }

        public boolean matchesSafely(View view) {
            float f;
            Rect rect = new Rect();
            boolean bl = view.getGlobalVisibleRect(rect);
            if (!bl) {
                return false;
            }
            Rect rect2 = this.getScreenWithoutStatusBarActionBar(view);
            float f2 = view.getHeight() > rect2.height() ? (float)rect2.height() : (float)view.getHeight();
            float f3 = f = view.getWidth() > rect2.width() ? (float)rect2.width() : (float)view.getWidth();
            if (Build.VERSION.SDK_INT >= 11) {
                f2 = Math.min((float)view.getHeight() * view.getScaleY(), (float)rect2.height());
                f = Math.min((float)view.getWidth() * view.getScaleX(), (float)rect2.width());
            }
            double d = f2 * f;
            double d2 = rect.height() * rect.width();
            int n = (int)(d2 / d * 100.0);
            return n >= this.areaPercentage && ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE).matches((Object)view);
        }

        private Rect getScreenWithoutStatusBarActionBar(View view) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)view.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n = view.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
            int n2 = n > 0 ? view.getContext().getResources().getDimensionPixelSize(n) : 0;
            TypedValue typedValue = new TypedValue();
            int n3 = view.getContext().getTheme().resolveAttribute(16843499, typedValue, true) ? TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)view.getContext().getResources().getDisplayMetrics()) : 0;
            return new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels - (n2 + n3));
        }
    }

    static final class IsDisplayedMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsDisplayedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is displayed on the screen to the user");
        }

        public boolean matchesSafely(View view) {
            return view.getGlobalVisibleRect(new Rect()) && ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE).matches((Object)view);
        }
    }

    static final class WithClassNameMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        final Matcher<String> classNameMatcher;

        @RemoteMsgConstructor
        private WithClassNameMatcher(Matcher<String> matcher) {
            this.classNameMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with class name: ");
            this.classNameMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.classNameMatcher.matches((Object)view.getClass().getName());
        }
    }

    static final class IsAssignableFromMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Class<?> clazz;

        @RemoteMsgConstructor
        private IsAssignableFromMatcher(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        public void describeTo(Description description) {
            String string = String.valueOf(this.clazz);
            description.appendText(new StringBuilder(26 + String.valueOf(string).length()).append("is assignable from class: ").append(string).toString());
        }

        public boolean matchesSafely(View view) {
            return this.clazz.isAssignableFrom(view.getClass());
        }
    }

    static final class WithTagKeyMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int key;
        @RemoteMsgField(order=1)
        private final Matcher<Object> objectMatcher;

        @RemoteMsgConstructor
        private WithTagKeyMatcher(int n, Matcher<Object> matcher) {
            this.key = n;
            this.objectMatcher = matcher;
        }

        public void describeTo(Description description) {
            int n = this.key;
            description.appendText(new StringBuilder(21).append("with key: ").append(n).toString());
            this.objectMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.objectMatcher.matches(view.getTag(this.key));
        }
    }

    static final class WithResourceNameMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithResourceNameMatcher(Matcher<String> matcher) {
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with res-name that ");
            this.stringMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            if (view.getId() == -1 || view.getResources() == null) {
                return false;
            }
            try {
                return this.stringMatcher.matches((Object)view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {
                return false;
            }
        }
    }

    static final class WithTextMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithTextMatcher(Matcher<String> matcher) {
            super(TextView.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with text: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(TextView textView) {
            CharSequence charSequence;
            String string = textView.getText().toString();
            if (this.stringMatcher.matches((Object)string)) {
                return true;
            }
            if (textView.getTransformationMethod() != null && (charSequence = textView.getTransformationMethod().getTransformation((CharSequence)string, (View)textView)) != null) {
                return this.stringMatcher.matches((Object)charSequence.toString());
            }
            return false;
        }
    }

    static final class WithIdMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        Matcher<Integer> viewIdMatcher;
        private Resources resources;

        @RemoteMsgConstructor
        private WithIdMatcher(Matcher<Integer> matcher) {
            this.viewIdMatcher = matcher;
        }

        public void describeTo(Description description) {
            String string = this.viewIdMatcher.toString().replaceAll("\\D+", "");
            int n = Integer.parseInt(string);
            if (this.resources != null) {
                try {
                    string = this.resources.getResourceName(n);
                }
                catch (Resources.NotFoundException notFoundException) {
                    string = String.format("%s (resource name not found)", string);
                }
            }
            String string2 = String.valueOf(string);
            description.appendText(string2.length() != 0 ? "with id: ".concat(string2) : new String("with id: "));
        }

        public boolean matchesSafely(View view) {
            this.resources = view.getResources();
            return this.viewIdMatcher.matches((Object)view.getId());
        }
    }

    public static enum Visibility {
        VISIBLE(0),
        INVISIBLE(4),
        GONE(8);

        private final int value;

        private Visibility(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

