/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

abstract class AbstractTransformFuture<I, O, F, T>
extends AbstractFuture.TrustedFuture<O>
implements Runnable {
    ListenableFuture<? extends I> inputFuture;
    F function;

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> transformFuture = new TransformFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(transformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, transformFuture));
        return transformFuture;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> listenableFuture, F f) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t;
        I i;
        ListenableFuture<? extends I> listenableFuture = this.inputFuture;
        F f = this.function;
        if (this.isCancelled() | listenableFuture == null | f == null) {
            return;
        }
        this.inputFuture = null;
        try {
            i = Futures.getDone(listenableFuture);
        }
        catch (CancellationException cancellationException) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException executionException) {
            this.setException(executionException.getCause());
            return;
        }
        catch (RuntimeException runtimeException) {
            this.setException(runtimeException);
            return;
        }
        catch (Error error) {
            this.setException(error);
            return;
        }
        try {
            t = this.doTransform(f, i);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.setException(undeclaredThrowableException.getCause());
            return;
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(t);
    }

    abstract T doTransform(F var1, I var2) throws Exception;

    abstract void setResult(T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    protected String pendingToString() {
        String string;
        ListenableFuture<? extends I> listenableFuture = this.inputFuture;
        F f = this.function;
        String string2 = super.pendingToString();
        String string3 = "";
        if (listenableFuture != null) {
            string = String.valueOf(listenableFuture);
            string3 = new StringBuilder(16 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("], ").toString();
        }
        if (f != null) {
            string = string3;
            String string4 = String.valueOf(f);
            return new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append("function=[").append(string4).append("]").toString();
        }
        if (string2 != null) {
            String string5 = String.valueOf(string3);
            String string6 = String.valueOf(string2);
            return string6.length() != 0 ? string5.concat(string6) : new String(string5);
        }
        return null;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> listenableFuture, Function<? super I, ? extends O> function) {
            super(listenableFuture, function);
        }

        @Override
        O doTransform(Function<? super I, ? extends O> function, I i) {
            return function.apply(i);
        }

        @Override
        void setResult(O o) {
            this.set(o);
        }
    }
}

