/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Ascii;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.FluentFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends FluentFuture<V> {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == Waiter.TOMBSTONE) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected AbstractFuture() {
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l2;
        Object object3;
        long l3;
        block11: {
            l3 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.value;
            if (object3 != null & !(object3 instanceof SetFuture)) {
                return this.getDoneValue(object3);
            }
            long l4 = l2 = l3 > 0L ? System.nanoTime() + l3 : 0L;
            if (l3 >= 1000L) {
                object2 = this.waiters;
                if (object2 != Waiter.TOMBSTONE) {
                    object = new Waiter();
                    do {
                        ((Waiter)object).setNext((Waiter)object2);
                        if (!ATOMIC_HELPER.casWaiters(this, (Waiter)object2, (Waiter)object)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.removeWaiter((Waiter)object);
                                throw new InterruptedException();
                            }
                            object3 = this.value;
                            if (!(object3 != null & !(object3 instanceof SetFuture))) continue;
                            return this.getDoneValue(object3);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.removeWaiter((Waiter)object);
                        break block11;
                    } while ((object2 = this.waiters) != Waiter.TOMBSTONE);
                }
                return this.getDoneValue(this.value);
            }
        }
        while (l3 > 0L) {
            object3 = this.value;
            if (object3 != null & !(object3 instanceof SetFuture)) {
                return this.getDoneValue(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        object2 = this.toString();
        if (this.isDone()) {
            object = Ascii.toLowerCase(timeUnit.toString());
            throw new TimeoutException(new StringBuilder(68 + String.valueOf(object).length()).append("Waited ").append(l).append(" ").append((String)object).append(" but future completed as timeout expired").toString());
        }
        object = Ascii.toLowerCase(timeUnit.toString());
        throw new TimeoutException(new StringBuilder(33 + String.valueOf(object).length() + String.valueOf(object2).length()).append("Waited ").append(l).append(" ").append((String)object).append(" for ").append((String)object2).toString());
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof SetFuture)) {
            return this.getDoneValue(object);
        }
        Waiter waiter = this.waiters;
        if (waiter != Waiter.TOMBSTONE) {
            Waiter waiter2 = new Waiter();
            do {
                waiter2.setNext(waiter);
                if (!ATOMIC_HELPER.casWaiters(this, waiter, waiter2)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(waiter2);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof SetFuture)));
                return this.getDoneValue(object);
            } while ((waiter = this.waiters) != Waiter.TOMBSTONE);
        }
        return this.getDoneValue(this.value);
    }

    private V getDoneValue(Object object) throws ExecutionException {
        if (object instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
        }
        if (object instanceof Failure) {
            throw new ExecutionException(((Failure)object).exception);
        }
        if (object == NULL) {
            return null;
        }
        Object object2 = object;
        return (V)object2;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof SetFuture);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value;
        return object instanceof Cancellation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancel(boolean bl) {
        Object object = this.value;
        boolean bl2 = false;
        if (!(object == null | object instanceof SetFuture)) return bl2;
        Cancellation cancellation = GENERATE_CANCELLATION_CAUSES ? new Cancellation(bl, new CancellationException("Future.cancel() was called.")) : (bl ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
        AbstractFuture abstractFuture = this;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                bl2 = true;
                if (bl) {
                    abstractFuture.interruptTask();
                }
                AbstractFuture.complete(abstractFuture);
                if (!(object instanceof SetFuture)) return bl2;
                ListenableFuture listenableFuture = ((SetFuture)object).future;
                if (listenableFuture instanceof TrustedFuture) {
                    AbstractFuture abstractFuture2 = (AbstractFuture)listenableFuture;
                    object = abstractFuture2.value;
                    if (!(object == null | object instanceof SetFuture)) return bl2;
                    abstractFuture = abstractFuture2;
                    continue;
                }
                listenableFuture.cancel(bl);
                return bl2;
            }
            object = abstractFuture.value;
            if (!(object instanceof SetFuture)) return bl2;
        }
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof Cancellation && ((Cancellation)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        Listener listener = this.listeners;
        if (listener != Listener.TOMBSTONE) {
            Listener listener2 = new Listener(runnable, executor);
            do {
                listener2.next = listener;
                if (!ATOMIC_HELPER.casListeners(this, listener, listener2)) continue;
                return;
            } while ((listener = this.listeners) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    protected boolean set(V v) {
        Object object;
        Object object2 = object = v == null ? NULL : v;
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        Failure failure = new Failure(Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, failure)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    private static Object getFutureValue(ListenableFuture<?> listenableFuture) {
        Object object;
        if (listenableFuture instanceof TrustedFuture) {
            Object object2 = ((AbstractFuture)listenableFuture).value;
            if (object2 instanceof Cancellation) {
                Cancellation cancellation = (Cancellation)object2;
                if (cancellation.wasInterrupted) {
                    object2 = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            return object2;
        }
        try {
            Object obj = Futures.getDone(listenableFuture);
            object = obj == null ? NULL : obj;
        }
        catch (ExecutionException executionException) {
            object = new Failure(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            object = new Cancellation(false, cancellationException);
        }
        catch (Throwable throwable) {
            object = new Failure(throwable);
        }
        return object;
    }

    private static void complete(AbstractFuture<?> abstractFuture) {
        Listener listener = null;
        block0: while (true) {
            super.releaseWaiters();
            abstractFuture.afterDone();
            listener = super.clearListeners(listener);
            abstractFuture = null;
            while (listener != null) {
                Listener listener2 = listener;
                listener = listener.next;
                Runnable runnable = listener2.task;
                if (runnable instanceof SetFuture) {
                    Object object;
                    SetFuture setFuture = (SetFuture)runnable;
                    abstractFuture = setFuture.owner;
                    if (abstractFuture.value != setFuture || !ATOMIC_HELPER.casValue(abstractFuture, setFuture, object = AbstractFuture.getFutureValue(setFuture.future))) continue;
                    continue block0;
                }
                AbstractFuture.executeListener(runnable, listener2.executor);
            }
            break;
        }
    }

    protected void afterDone() {
    }

    final void maybePropagateCancellationTo(Future<?> future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    private void releaseWaiters() {
        Waiter waiter;
        while (!ATOMIC_HELPER.casWaiters(this, waiter = this.waiters, Waiter.TOMBSTONE)) {
        }
        Waiter waiter2 = waiter;
        while (waiter2 != null) {
            waiter2.unpark();
            waiter2 = waiter2.next;
        }
    }

    private Listener clearListeners(Listener listener) {
        Listener listener2;
        while (!ATOMIC_HELPER.casListeners(this, listener2 = this.listeners, Listener.TOMBSTONE)) {
        }
        Listener listener3 = listener;
        while (listener2 != null) {
            Listener listener4 = listener2;
            listener2 = listener2.next;
            listener4.next = listener3;
            listener3 = listener4;
        }
        return listener3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            String string;
            try {
                string = this.pendingToString();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getClass());
                string = new StringBuilder(38 + String.valueOf(string2).length()).append("Exception thrown from implementation: ").append(string2).toString();
            }
            if (!Strings.isNullOrEmpty(string)) {
                stringBuilder.append("PENDING, info=[").append(string).append("]");
            } else if (this.isDone()) {
                this.addDoneString(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        return stringBuilder.append("]").toString();
    }

    protected String pendingToString() {
        Object object = this.value;
        if (object instanceof SetFuture) {
            String string = this.userObjectToString(((SetFuture)object).future);
            return new StringBuilder(12 + String.valueOf(string).length()).append("setFuture=[").append(string).append("]").toString();
        }
        if (this instanceof ScheduledFuture) {
            long l = ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS);
            return new StringBuilder(41).append("remaining delay=[").append(l).append(" ms]").toString();
        }
        return null;
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            Object v = Futures.getDone(this);
            stringBuilder.append("SUCCESS, result=[").append(this.userObjectToString(v)).append("]");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
        }
    }

    private String userObjectToString(Object object) {
        if (object == this) {
            return "this future";
        }
        return String.valueOf(object);
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            String string = String.valueOf(runnable);
            String string2 = String.valueOf(executor);
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "executeListener", new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RuntimeException while executing runnable ").append(string).append(" with executor ").append(string2).toString(), runtimeException);
        }
    }

    private static CancellationException cancellationExceptionWithCause(String string, Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    static {
        AtomicHelper atomicHelper;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        log = Logger.getLogger(AbstractFuture.class.getName());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            atomicHelper = new UnsafeAtomicHelper();
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            try {
                atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                atomicHelper = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = atomicHelper;
        Class<LockSupport> clazz = LockSupport.class;
        if (throwable2 != null) {
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).waiters == waiter) {
                    ((AbstractFuture)abstractFuture).waiters = waiter2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).listeners == listener) {
                    ((AbstractFuture)abstractFuture).listeners = listener2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).value == object) {
                    ((AbstractFuture)abstractFuture).value = object2;
                    return true;
                }
                return false;
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<AbstractFuture, Waiter> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<AbstractFuture, Listener> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<AbstractFuture, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return this.waitersUpdater.compareAndSet(abstractFuture, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return this.listenersUpdater.compareAndSet(abstractFuture, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(abstractFuture, object, object2);
        }
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        private UnsafeAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, VALUE_OFFSET, object, object2);
        }

        static {
            Unsafe unsafe = null;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : clazz.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<AbstractFuture> clazz = AbstractFuture.class;
                WAITERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("waiters"));
                LISTENERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("listeners"));
                VALUE_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = unsafe;
            }
            catch (Exception exception) {
                Throwables.throwIfUnchecked(exception);
                throw new RuntimeException(exception);
            }
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void putThread(Waiter var1, Thread var2);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract boolean casWaiters(AbstractFuture<?> var1, Waiter var2, Waiter var3);

        abstract boolean casListeners(AbstractFuture<?> var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractFuture<?> var1, Object var2, Object var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = AbstractFuture.getFutureValue(this.future);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        Cancellation(boolean bl, Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = Preconditions.checkNotNull(throwable);
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE = new Listener(null, null);
        final Runnable task;
        final Executor executor;
        Listener next;

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        volatile Thread thread;
        volatile Waiter next;

        Waiter(boolean bl) {
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V> {
        TrustedFuture() {
        }

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl) {
            return super.cancel(bl);
        }
    }
}

