/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.TransformedIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T t = iterator.next();
        if (!iterator.hasNext()) {
            return t;
        }
        StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(t);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            stringBuilder.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> clazz) {
        ArrayList<? extends T> arrayList = Lists.newArrayList(iterator);
        return Iterables.toArray(arrayList, clazz);
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.apply(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator){

            @Override
            T transform(F f) {
                return function.apply(f);
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final T t) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t;
            }
        };
    }
}

