/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingUiController;
import androidx.test.espresso.base.Interrogator;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.inject.Provider;

final class UiControllerImpl
implements Handler.Callback,
IdlingUiController,
InterruptableUiController {
    private static final String TAG = UiControllerImpl.class.getSimpleName();
    private static final Callable<Void> NO_OP = new Callable<Void>(){

        @Override
        public Void call() {
            return null;
        }
    };
    private final EventInjector eventInjector;
    private final BitSet conditionSet;
    private final ExecutorService keyEventExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Espresso Key Event #%d").build());
    private final Looper mainLooper;
    private final IdlingResourceRegistry idlingResourceRegistry;
    private Handler controllerHandler;
    private MainThreadInterrogation interrogation;
    private int generation = 0;
    private IdleNotifier<Runnable> asyncIdle;
    private IdleNotifier<Runnable> compatIdle;
    private Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdleProvider;

    UiControllerImpl(EventInjector eventInjector, @SdkAsyncTask IdleNotifier<Runnable> idleNotifier, @CompatAsyncTask IdleNotifier<Runnable> idleNotifier2, Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> provider, Looper looper, IdlingResourceRegistry idlingResourceRegistry) {
        this.eventInjector = Preconditions.checkNotNull(eventInjector);
        this.asyncIdle = Preconditions.checkNotNull(idleNotifier);
        this.compatIdle = Preconditions.checkNotNull(idleNotifier2);
        this.conditionSet = IdleCondition.createConditionSet();
        this.dynamicIdleProvider = Preconditions.checkNotNull(provider);
        this.mainLooper = Preconditions.checkNotNull(looper);
        this.idlingResourceRegistry = Preconditions.checkNotNull(idlingResourceRegistry);
    }

    @Override
    public boolean injectKeyEvent(final KeyEvent keyEvent) throws InjectEventSecurityException {
        Preconditions.checkNotNull(keyEvent);
        Preconditions.checkState(Looper.myLooper() == this.mainLooper, "Expecting to be on main thread!");
        this.initialize();
        this.loopMainThreadUntilIdle();
        SignalingTask<Boolean> signalingTask = new SignalingTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UiControllerImpl.this.eventInjector.injectKeyEvent(keyEvent);
            }
        }, IdleCondition.KEY_INJECT_HAS_COMPLETED, this.generation);
        Future<?> future = this.keyEventExecutor.submit(signalingTask);
        this.loopUntil(IdleCondition.KEY_INJECT_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(signalingTask.isDone(), "Key injection was signaled - but it wasnt done.");
            return (Boolean)signalingTask.get();
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof InjectEventSecurityException) {
                throw (InjectEventSecurityException)((Object)executionException.getCause());
            }
            throw new RuntimeException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("impossible.", interruptedException);
        }
    }

    @Override
    public boolean injectMotionEvent(final MotionEvent motionEvent) throws InjectEventSecurityException {
        Preconditions.checkNotNull(motionEvent);
        Preconditions.checkState(Looper.myLooper() == this.mainLooper, "Expecting to be on main thread!");
        this.initialize();
        SignalingTask<Boolean> signalingTask = new SignalingTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UiControllerImpl.this.eventInjector.injectMotionEvent(motionEvent);
            }
        }, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        Future<?> future = this.keyEventExecutor.submit(signalingTask);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(signalingTask.isDone(), "Key injection was signaled - but it wasnt done.");
            boolean bl = (Boolean)signalingTask.get();
            return bl;
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof InjectEventSecurityException) {
                throw (InjectEventSecurityException)((Object)executionException.getCause());
            }
            Throwables.throwIfUnchecked(executionException.getCause() != null ? executionException.getCause() : executionException);
            throw new RuntimeException(executionException.getCause() != null ? executionException.getCause() : executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.loopMainThreadUntilIdle();
        }
    }

    @Override
    public boolean injectString(String string) throws InjectEventSecurityException {
        Preconditions.checkNotNull(string);
        Preconditions.checkState(Looper.myLooper() == this.mainLooper, "Expecting to be on main thread!");
        this.initialize();
        if (string.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return true;
        }
        boolean bl = false;
        KeyCharacterMap keyCharacterMap = UiControllerImpl.getKeyCharacterMap();
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(string.toCharArray());
        if (keyEventArray == null) {
            throw new RuntimeException(String.format("Failed to get key events for string %s (i.e. current IME does not understand how to translate the string into key events). As a workaround, you can use replaceText action to set the text directly in the EditText field.", string));
        }
        Log.d((String)TAG, (String)String.format("Injecting string: \"%s\"", string));
        for (KeyEvent keyEvent : keyEventArray) {
            Preconditions.checkNotNull(keyEvent, String.format("Failed to get event for character (%c) with key code (%s)", keyEvent.getKeyCode(), keyEvent.getUnicodeChar()));
            bl = false;
            for (int i = 0; !bl && i < 4; ++i) {
                keyEvent = KeyEvent.changeTimeRepeat((KeyEvent)keyEvent, (long)SystemClock.uptimeMillis(), (int)0);
                bl = this.injectKeyEvent(keyEvent);
            }
            if (bl) continue;
            Log.e((String)TAG, (String)String.format("Failed to inject event for character (%c) with key code (%s)", keyEvent.getUnicodeChar(), keyEvent.getKeyCode()));
            break;
        }
        return bl;
    }

    @SuppressLint(value={"InlinedApi"})
    public static KeyCharacterMap getKeyCharacterMap() {
        KeyCharacterMap keyCharacterMap = null;
        keyCharacterMap = Build.VERSION.SDK_INT < 11 ? KeyCharacterMap.load((int)0) : KeyCharacterMap.load((int)-1);
        return keyCharacterMap;
    }

    @Override
    public IdlingResourceRegistry getIdlingResourceRegistry() {
        return this.idlingResourceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loopMainThreadUntilIdle() {
        this.initialize();
        Preconditions.checkState(Looper.myLooper() == this.mainLooper, "Expecting to be on main thread!");
        IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> idleNotifier = (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)this.dynamicIdleProvider.get();
        do {
            EnumSet<IdleCondition> enumSet = EnumSet.noneOf(IdleCondition.class);
            if (!this.asyncIdle.isIdleNow()) {
                this.asyncIdle.registerNotificationCallback(new SignalingTask<Void>(NO_OP, IdleCondition.ASYNC_TASKS_HAVE_IDLED, this.generation));
                enumSet.add(IdleCondition.ASYNC_TASKS_HAVE_IDLED);
            }
            if (!this.compatIdle.isIdleNow()) {
                this.compatIdle.registerNotificationCallback(new SignalingTask<Void>(NO_OP, IdleCondition.COMPAT_TASKS_HAVE_IDLED, this.generation));
                enumSet.add(IdleCondition.COMPAT_TASKS_HAVE_IDLED);
            }
            if (!idleNotifier.isIdleNow()) {
                final IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
                final IdlingPolicy idlingPolicy2 = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
                final SignalingTask<Void> signalingTask = new SignalingTask<Void>(NO_OP, IdleCondition.DYNAMIC_TASKS_HAVE_IDLED, this.generation);
                idleNotifier.registerNotificationCallback(new IdlingResourceRegistry.IdleNotificationCallback(){

                    @Override
                    public void resourcesStillBusyWarning(List<String> list) {
                        idlingPolicy.handleTimeout(list, "IdlingResources are still busy!");
                    }

                    @Override
                    public void resourcesHaveTimedOut(List<String> list) {
                        idlingPolicy2.handleTimeout(list, "IdlingResources have timed out!");
                        UiControllerImpl.this.controllerHandler.post((Runnable)signalingTask);
                    }

                    @Override
                    public void allResourcesIdle() {
                        UiControllerImpl.this.controllerHandler.post((Runnable)signalingTask);
                    }
                });
                enumSet.add(IdleCondition.DYNAMIC_TASKS_HAVE_IDLED);
            }
            try {
                idleNotifier = this.loopUntil(enumSet, idleNotifier);
            }
            finally {
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                idleNotifier.cancelCallback();
            }
        } while (!this.asyncIdle.isIdleNow() || !this.compatIdle.isIdleNow() || !idleNotifier.isIdleNow());
    }

    @Override
    public void loopMainThreadForAtLeast(long l) {
        this.initialize();
        Preconditions.checkState(Looper.myLooper() == this.mainLooper, "Expecting to be on main thread!");
        Preconditions.checkState(!IdleCondition.DELAY_HAS_PAST.isSignaled(this.conditionSet), "recursion detected!");
        Preconditions.checkArgument(l > 0L);
        this.controllerHandler.postAtTime(new SignalingTask<Void>(NO_OP, IdleCondition.DELAY_HAS_PAST, this.generation), (Object)this.generation, SystemClock.uptimeMillis() + l);
        this.loopUntil(IdleCondition.DELAY_HAS_PAST, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        this.loopMainThreadUntilIdle();
    }

    public boolean handleMessage(Message message) {
        if (!IdleCondition.handleMessage(message, this.conditionSet, this.generation)) {
            String string = String.valueOf(message);
            Log.i((String)TAG, (String)new StringBuilder(22 + String.valueOf(string).length()).append("Unknown message type: ").append(string).toString());
            return false;
        }
        return true;
    }

    private void loopUntil(IdleCondition idleCondition, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> idleNotifier) {
        this.loopUntil(EnumSet.of(idleCondition), idleNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> loopUntil(EnumSet<IdleCondition> enumSet, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> idleNotifier) {
        IdlingPolicy idlingPolicy = IdlingPolicies.getMasterIdlingPolicy();
        try {
            long l = SystemClock.uptimeMillis();
            long l2 = l + idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout());
            this.interrogation = new MainThreadInterrogation(enumSet, this.conditionSet, l2);
            InterrogationStatus interrogationStatus = Interrogator.loopAndInterrogate(this.interrogation);
            if (InterrogationStatus.COMPLETED == interrogationStatus) {
                IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> idleNotifier2 = idleNotifier;
                return idleNotifier2;
            }
            if (InterrogationStatus.INTERRUPTED == interrogationStatus) {
                Log.w((String)TAG, (String)"Espresso interrogation of the main thread is interrupted");
                throw new RuntimeException("Espresso interrogation of the main thread is interrupted");
            }
            ArrayList<String> arrayList = Lists.newArrayList();
            for (IdleCondition idleCondition : enumSet) {
                if (idleCondition.isSignaled(this.conditionSet)) continue;
                arrayList.add(idleCondition.name());
            }
            idlingPolicy.handleTimeout(arrayList, String.format("Looped for %s iterations over %s %s.", this.interrogation.execCount, idlingPolicy.getIdleTimeout(), idlingPolicy.getIdleTimeoutUnit().name()));
        }
        finally {
            ++this.generation;
            for (IdleCondition idleCondition : enumSet) {
                idleCondition.reset(this.conditionSet);
            }
            this.interrogation = null;
        }
        return idleNotifier;
    }

    @Override
    public void interruptEspressoTasks() {
        this.initialize();
        this.controllerHandler.post(new Runnable(){

            @Override
            public void run() {
                if (UiControllerImpl.this.interrogation != null) {
                    UiControllerImpl.this.interrogation.interruptInterrogation();
                    UiControllerImpl.this.controllerHandler.removeCallbacksAndMessages((Object)UiControllerImpl.this.generation);
                }
            }
        });
    }

    private void initialize() {
        if (this.controllerHandler == null) {
            this.controllerHandler = new Handler((Handler.Callback)this);
        }
    }

    private class SignalingTask<T>
    extends FutureTask<T> {
        private final IdleCondition condition;
        private final int myGeneration;

        public SignalingTask(Callable<T> callable, IdleCondition idleCondition, int n) {
            super(callable);
            this.condition = Preconditions.checkNotNull(idleCondition);
            this.myGeneration = n;
        }

        @Override
        protected void done() {
            UiControllerImpl.this.controllerHandler.sendMessage(this.condition.createSignal(UiControllerImpl.this.controllerHandler, this.myGeneration));
        }
    }

    private static final class MainThreadInterrogation
    implements Interrogator.InterrogationHandler<InterrogationStatus> {
        private final EnumSet<IdleCondition> conditions;
        private final BitSet conditionSet;
        private final long giveUpAtMs;
        private InterrogationStatus status = InterrogationStatus.COMPLETED;
        private int execCount = 0;

        MainThreadInterrogation(EnumSet<IdleCondition> enumSet, BitSet bitSet, long l) {
            this.conditions = enumSet;
            this.conditionSet = bitSet;
            this.giveUpAtMs = l;
        }

        @Override
        public void quitting() {
        }

        @Override
        public boolean barrierUp() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean queueEmpty() {
            return !this.conditionsMet();
        }

        @Override
        public boolean taskDueSoon() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean taskDueLong() {
            return !this.conditionsMet();
        }

        @Override
        public boolean beforeTaskDispatch() {
            ++this.execCount;
            return this.continueOrTimeout();
        }

        private boolean continueOrTimeout() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return false;
            }
            if (SystemClock.uptimeMillis() >= this.giveUpAtMs) {
                this.status = InterrogationStatus.TIMED_OUT;
                return false;
            }
            return true;
        }

        void interruptInterrogation() {
            this.status = InterrogationStatus.INTERRUPTED;
        }

        @Override
        public InterrogationStatus get() {
            return this.status;
        }

        private boolean conditionsMet() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return true;
            }
            boolean bl = true;
            boolean bl2 = this.execCount > 0 && this.execCount % 100 == 0;
            for (IdleCondition idleCondition : this.conditions) {
                if (idleCondition.isSignaled(this.conditionSet)) continue;
                bl = false;
                if (!bl2) break;
                String string = idleCondition.name();
                int n = this.execCount;
                Log.w((String)TAG, (String)new StringBuilder(41 + String.valueOf(string).length()).append("Waiting for: ").append(string).append(" for ").append(n).append(" iterations.").toString());
            }
            return bl;
        }
    }

    private static enum InterrogationStatus {
        TIMED_OUT,
        COMPLETED,
        INTERRUPTED;

    }

    static enum IdleCondition {
        DELAY_HAS_PAST,
        ASYNC_TASKS_HAVE_IDLED,
        COMPAT_TASKS_HAVE_IDLED,
        KEY_INJECT_HAS_COMPLETED,
        MOTION_INJECTION_HAS_COMPLETED,
        DYNAMIC_TASKS_HAVE_IDLED;


        public boolean isSignaled(BitSet bitSet) {
            return bitSet.get(this.ordinal());
        }

        public void reset(BitSet bitSet) {
            bitSet.set(this.ordinal(), false);
        }

        public Message createSignal(Handler handler, int n) {
            return Message.obtain((Handler)handler, (int)this.ordinal(), (int)n, (int)0, null);
        }

        public static boolean handleMessage(Message message, BitSet bitSet, int n) {
            IdleCondition[] idleConditionArray = IdleCondition.values();
            if (message.what < 0 || message.what >= idleConditionArray.length) {
                return false;
            }
            IdleCondition idleCondition = idleConditionArray[message.what];
            if (message.arg1 == n) {
                idleCondition.signal(bitSet);
            } else {
                String string = String.valueOf((Object)idleCondition);
                int n2 = message.arg1;
                Log.w((String)TAG, (String)new StringBuilder(90 + String.valueOf(string).length()).append("ignoring signal of: ").append(string).append(" from previous generation: ").append(n2).append(" current generation: ").append(n).toString());
            }
            return true;
        }

        public static BitSet createConditionSet() {
            return new BitSet(IdleCondition.values().length);
        }

        protected void signal(BitSet bitSet) {
            bitSet.set(this.ordinal());
        }
    }
}

