/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class InputManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = InputManagerEventInjectionStrategy.class.getSimpleName();
    private static final long KEYBOARD_DISMISSAL_DELAY_MILLIS = 1000L;
    private boolean initComplete;
    private Method injectInputEventMethod;
    private Method setSourceMotionMethod;
    private Object instanceInputManagerObject;
    private int eventMode;

    InputManagerEventInjectionStrategy() {
        Preconditions.checkState(Build.VERSION.SDK_INT >= 16, "Unsupported API level.");
    }

    void initialize() {
        if (this.initComplete) {
            return;
        }
        try {
            Log.d((String)TAG, (String)"Creating injection strategy with input manager.");
            Class<?> clazz = Class.forName("android.hardware.input.InputManager");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            this.instanceInputManagerObject = method.invoke(clazz, new Object[0]);
            this.injectInputEventMethod = this.instanceInputManagerObject.getClass().getDeclaredMethod("injectInputEvent", InputEvent.class, Integer.TYPE);
            this.injectInputEventMethod.setAccessible(true);
            Field field = clazz.getField("INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH");
            field.setAccessible(true);
            this.eventMode = field.getInt(clazz);
            this.setSourceMotionMethod = MotionEvent.class.getDeclaredMethod("setSource", Integer.TYPE);
            this.initComplete = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    @Override
    public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        try {
            return (Boolean)this.injectInputEventMethod.invoke(this.instanceInputManagerObject, keyEvent, this.eventMode);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SecurityException) {
                throw new InjectEventSecurityException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new InjectEventSecurityException(securityException);
        }
    }

    @Override
    public boolean injectMotionEvent(MotionEvent motionEvent) throws InjectEventSecurityException {
        return this.innerInjectMotionEvent(motionEvent, true);
    }

    private boolean innerInjectMotionEvent(MotionEvent motionEvent, boolean bl) throws InjectEventSecurityException {
        try {
            if ((motionEvent.getSource() & 2) == 0 && !InputManagerEventInjectionStrategy.isFromTouchpadInGlassDevice(motionEvent)) {
                this.setSourceMotionMethod.invoke((Object)motionEvent, 4098);
            }
            return (Boolean)this.injectInputEventMethod.invoke(this.instanceInputManagerObject, motionEvent, this.eventMode);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SecurityException) {
                if (bl) {
                    Log.w((String)TAG, (String)"Error performing a ViewAction! soft keyboard dismissal animation may have been in the way. Retrying once after: 1000 millis");
                    SystemClock.sleep((long)1000L);
                    this.innerInjectMotionEvent(motionEvent, false);
                }
                throw new InjectEventSecurityException(throwable);
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new InjectEventSecurityException(securityException);
        }
        return false;
    }

    private static boolean isFromTouchpadInGlassDevice(MotionEvent motionEvent) {
        return (Build.DEVICE.contains("glass") || Build.DEVICE.contains("Glass") || Build.DEVICE.contains("wingman")) && (motionEvent.getSource() & 0x100008) != 0;
    }
}

