/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;

public enum Swipe implements Swiper
{
    FAST{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
            return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 100);
        }
    }
    ,
    SLOW{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
            return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 1500);
        }
    };

    private static final String TAG;
    private static final int SWIPE_EVENT_COUNT = 10;
    private static final int SWIPE_FAST_DURATION_MS = 100;
    private static final int SWIPE_SLOW_DURATION_MS = 1500;

    private static float[][] interpolate(float[] fArray, float[] fArray2, int n) {
        Preconditions.checkElementIndex(1, fArray.length);
        Preconditions.checkElementIndex(1, fArray2.length);
        float[][] fArray3 = new float[n][2];
        for (int i = 1; i < n + 1; ++i) {
            fArray3[i - 1][0] = fArray[0] + (fArray2[0] - fArray[0]) * (float)i / ((float)n + 2.0f);
            fArray3[i - 1][1] = fArray[1] + (fArray2[1] - fArray[1]) * (float)i / ((float)n + 2.0f);
        }
        return fArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Swiper.Status sendLinearSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3, int n) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        Preconditions.checkNotNull(fArray3);
        float[][] fArray4 = Swipe.interpolate(fArray, fArray2, 10);
        int n2 = n / fArray4.length;
        MotionEvent motionEvent = MotionEvents.sendDown((UiController)uiController, (float[])fArray, (float[])fArray3).down;
        try {
            for (int i = 0; i < fArray4.length; ++i) {
                if (!MotionEvents.sendMovement(uiController, motionEvent, fArray4[i])) {
                    Log.e((String)TAG, (String)"Injection of move event as part of the swipe failed. Sending cancel event.");
                    MotionEvents.sendCancel(uiController, motionEvent);
                    Swiper.Status status = Swiper.Status.FAILURE;
                    return status;
                }
                long l = motionEvent.getDownTime() + (long)(n2 * i);
                long l2 = l - SystemClock.uptimeMillis();
                if (l2 <= 10L) continue;
                uiController.loopMainThreadForAtLeast(l2);
            }
            if (!MotionEvents.sendUp(uiController, motionEvent, fArray2)) {
                Log.e((String)TAG, (String)"Injection of up event as part of the swipe failed. Sending cancel event.");
                MotionEvents.sendCancel(uiController, motionEvent);
                Swiper.Status status = Swiper.Status.FAILURE;
                return status;
            }
        }
        finally {
            motionEvent.recycle();
        }
        return Swiper.Status.SUCCESS;
    }

    static {
        TAG = Swipe.class.getSimpleName();
    }
}

