/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class GeneralClickAction
implements ViewAction {
    private static final String TAG = "GeneralClickAction";
    final CoordinatesProvider coordinatesProvider;
    final Tapper tapper;
    final PrecisionDescriber precisionDescriber;
    private final Optional<ViewAction> rollbackAction;
    private final int inputDevice;
    private final int buttonState;

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, null);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int n, int n2) {
        this(tapper, coordinatesProvider, precisionDescriber, n, n2, null);
    }

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, ViewAction viewAction) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, viewAction);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int n, int n2, ViewAction viewAction) {
        this.coordinatesProvider = coordinatesProvider;
        this.tapper = tapper;
        this.precisionDescriber = precisionDescriber;
        this.inputDevice = n;
        this.buttonState = n2;
        this.rollbackAction = Optional.fromNullable(viewAction);
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher<View> matcher = ViewMatchers.isDisplayingAtLeast(90);
        if (this.rollbackAction.isPresent()) {
            return Matchers.allOf(matcher, this.rollbackAction.get().getConstraints());
        }
        return matcher;
    }

    @Override
    public void perform(UiController uiController, View view) {
        int n;
        float[] fArray = this.coordinatesProvider.calculateCoordinates(view);
        float[] fArray2 = this.precisionDescriber.describePrecision();
        Tapper.Status status = Tapper.Status.FAILURE;
        for (n = 0; status != Tapper.Status.SUCCESS && n < 3; ++n) {
            try {
                status = this.tapper.sendTap(uiController, fArray, fArray2, this.inputDevice, this.buttonState);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    String string = String.valueOf(String.format("%s - At Coordinates: %d, %d and precision: %d, %d", this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1]));
                    Log.d((String)TAG, (String)(string.length() != 0 ? "perform: ".concat(string) : new String("perform: ")));
                }
            }
            catch (RuntimeException runtimeException) {
                throw new PerformException.Builder().withActionDescription(String.format("%s - At Coordinates: %d, %d and precision: %d, %d", this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1])).withViewDescription(HumanReadables.describe(view)).withCause(runtimeException).build();
            }
            int n2 = ViewConfiguration.getPressedStateDuration();
            if (n2 > 0) {
                uiController.loopMainThreadForAtLeast(n2);
            }
            if (status != Tapper.Status.WARNING) continue;
            if (!this.rollbackAction.isPresent()) break;
            this.rollbackAction.get().perform(uiController, view);
        }
        if (status == Tapper.Status.FAILURE) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format("Couldn't click at: %s,%s precision: %s, %s . Tapper: %s coordinate provider: %s precision describer: %s. Tried %s times. With Rollback? %s", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), this.tapper, this.coordinatesProvider, this.precisionDescriber, n, this.rollbackAction.isPresent()))).build();
        }
        if (this.tapper == Tap.SINGLE && view instanceof WebView) {
            uiController.loopMainThreadForAtLeast(ViewConfiguration.getDoubleTapTimeout());
        }
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.tapper.toString().toLowerCase()).concat(" click");
    }
}

