/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.List;
import org.hamcrest.Matcher;

public final class NoMatchingViewException
extends RuntimeException
implements EspressoException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private List<View> adapterViews = Lists.newArrayList();
    private boolean includeViewHierarchy = true;
    private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();

    private NoMatchingViewException(String string) {
        super(string);
    }

    private NoMatchingViewException(Builder builder) {
        super(NoMatchingViewException.getErrorMessage(builder));
        this.viewMatcher = builder.viewMatcher;
        this.rootView = builder.rootView;
        this.adapterViews = builder.adapterViews;
        this.adapterViewWarning = builder.adapterViewWarning;
        this.includeViewHierarchy = builder.includeViewHierarchy;
    }

    public String getViewMatcherDescription() {
        String string = "unknown";
        if (null != this.viewMatcher) {
            string = this.viewMatcher.toString();
        }
        return string;
    }

    private static String getErrorMessage(Builder builder) {
        String string = "";
        if (builder.includeViewHierarchy) {
            String string2 = String.format("No views in hierarchy found matching: %s", builder.viewMatcher);
            if (builder.adapterViewWarning.isPresent()) {
                String string3 = String.valueOf(string2);
                String string4 = String.valueOf((String)builder.adapterViewWarning.get());
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            string = HumanReadables.getViewHierarchyErrorMessage(builder.rootView, null, string2, null);
        } else {
            string = String.format("Could not find a view that matches %s", builder.viewMatcher);
        }
        return string;
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private List<View> adapterViews = Lists.newArrayList();
        private boolean includeViewHierarchy = true;
        private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();

        public Builder from(NoMatchingViewException noMatchingViewException) {
            this.viewMatcher = noMatchingViewException.viewMatcher;
            this.rootView = noMatchingViewException.rootView;
            this.adapterViews = noMatchingViewException.adapterViews;
            this.adapterViewWarning = noMatchingViewException.adapterViewWarning;
            this.includeViewHierarchy = noMatchingViewException.includeViewHierarchy;
            return this;
        }

        public Builder withViewMatcher(Matcher<? super View> matcher) {
            this.viewMatcher = matcher;
            return this;
        }

        public Builder withRootView(View view) {
            this.rootView = view;
            return this;
        }

        public Builder withAdapterViews(List<View> list) {
            this.adapterViews = list;
            return this;
        }

        public Builder includeViewHierarchy(boolean bl) {
            this.includeViewHierarchy = bl;
            return this;
        }

        public Builder withAdapterViewWarning(EspressoOptional<String> espressoOptional) {
            this.adapterViewWarning = espressoOptional;
            return this;
        }

        public NoMatchingViewException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.adapterViews);
            Preconditions.checkNotNull(this.adapterViewWarning);
            return new NoMatchingViewException(this);
        }
    }
}

